/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.services.NewHireService;
import com.cbmportal.portal.services.TerminationService;
import com.cbmportal.portal.services.UniformService;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1/hr/"})
public class HrSubmissionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HrSubmissionController.class);
    private final TerminationService terminationService;
    private final UniformService uniformService;
    private final NewHireService newHireService;

    public HrSubmissionController(TerminationService terminationService, UniformService uniformService, NewHireService newHireService) {
        this.terminationService = terminationService;
        this.uniformService = uniformService;
        this.newHireService = newHireService;
    }

    @PostMapping(value={"terminationSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitTermination(@RequestBody Termination termination) {
        log.info("Termination submission received for employee: {}", termination.getEmployee() != null ? termination.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse formResponse = this.terminationService.processTermination(termination);
        log.info("Termination processed successfully");
        return ResponseEntity.ok((Object)formResponse);
    }

    @PostMapping(value={"uniformSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitUniform(@RequestBody Uniform uniform) {
        log.info("Uniform submission received for employee: {}", uniform.getEmployee() != null ? uniform.getEmployee().getEmployeeNumber() : "unknown");
        FormSubmissionResponse formResponse = this.uniformService.processUniform(uniform);
        log.info("Uniform processed successfully");
        return ResponseEntity.ok((Object)formResponse);
    }

    @PostMapping(value={"newHireSubmit"}, consumes={"multipart/form-data"})
    public ResponseEntity<FormSubmissionResponse> submitNewHire(@RequestPart(value="newHireInfoJSON") String newHireInfo, @RequestPart(value="idBadge") MultipartFile idBadge, @RequestPart(value="govIdFront") MultipartFile govIdFront, @RequestPart(value="govIdRear") MultipartFile govIdBack, @RequestPart(value="ssnCard") MultipartFile ssnCard, HttpServletResponse response) throws IOException {
        log.info("New hire submission received");
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        NewHire newHire = (NewHire)mapper.readValue(newHireInfo, NewHire.class);
        log.debug("Parsed new hire: {}", (Object)newHire);
        FormSubmissionResponse formResponse = this.newHireService.processNewHire(newHire, idBadge, govIdFront, govIdBack, ssnCard, response);
        log.info("New hire processed successfully for employee: {} {}", (Object)newHire.getEmployee().getEmployeeFirst(), (Object)newHire.getEmployee().getEmployeeLast());
        return ResponseEntity.ok((Object)formResponse);
    }
}

