/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class HealthController {
    @Value(value="${spring.application.name:CBM-Portal}")
    private String applicationName;
    @Value(value="${cbm-portal.version:1.0.0}")
    private String version;

    @GetMapping(value={"/health"})
    public ResponseEntity<Map<String, Object>> health() {
        HashMap<String, String> health = new HashMap<String, String>();
        health.put("status", "UP");
        health.put("application", this.applicationName);
        health.put("version", this.version);
        health.put("timestamp", LocalDateTime.now().toString());
        health.put("message", "Application is running");
        return ResponseEntity.ok(health);
    }

    @GetMapping(value={"/health/detailed"})
    public ResponseEntity<Map<String, Object>> detailedHealth() {
        HashMap<String, Object> health = new HashMap<String, Object>();
        health.put("status", "UP");
        health.put("application", this.applicationName);
        health.put("version", this.version);
        health.put("timestamp", LocalDateTime.now().toString());
        Runtime runtime = Runtime.getRuntime();
        HashMap<String, Object> systemInfo = new HashMap<String, Object>();
        systemInfo.put("availableProcessors", runtime.availableProcessors());
        systemInfo.put("freeMemory", runtime.freeMemory() / 0x100000L + " MB");
        systemInfo.put("totalMemory", runtime.totalMemory() / 0x100000L + " MB");
        systemInfo.put("maxMemory", runtime.maxMemory() / 0x100000L + " MB");
        health.put("system", systemInfo);
        return ResponseEntity.ok(health);
    }
}

