/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.controllers.FormAdminController;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.FormAdminResponseVO;
import com.cbmportal.portal.domains.VO.FormCountResponseVO;
import com.cbmportal.portal.domains.VO.PaginatedFormAdminResponseVO;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.services.admin.FormAdminService;
import com.cbmportal.portal.services.util.FormTypeResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/forms"})
@PreAuthorize(value="hasAnyAuthority('Admin','Office','DM')")
public class FormAdminController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormAdminController.class);
    private final FormAdminService formAdminService;
    private final PortalUserRepository portalUserRepository;

    public FormAdminController(FormAdminService formAdminService, PortalUserRepository portalUserRepository) {
        this.formAdminService = formAdminService;
        this.portalUserRepository = portalUserRepository;
    }

    private Authentication auth() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isAdminOrOffice(Authentication a) {
        if (a == null) {
            return false;
        }
        return a.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(r -> r.equals("Admin") || r.equals("Office"));
    }

    private boolean isDM(Authentication a) {
        if (a == null) {
            return false;
        }
        return a.getAuthorities().stream().anyMatch(ga -> ga.getAuthority().equals("DM"));
    }

    private Long currentUserId(Authentication a) {
        if (a == null) {
            return null;
        }
        String username = a.getName();
        return this.portalUserRepository.findByUserNameAndDisabledFalse(username).map(PortalUser::getId).orElse(null);
    }

    private <E> Page<E> paginate(List<E> items, Pageable pageable) {
        int total = items.size();
        int start = (int)Math.min(pageable.getOffset(), (long)total);
        int end = Math.min(start + pageable.getPageSize(), total);
        List<E> content = items.subList(start, end);
        return new PageImpl(content, pageable, (long)total);
    }

    private ResponseEntity<?> buildUnknownFormNameResponse(String formName) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("error", "Unknown formName");
        body.put("formName", formName);
        body.put("validOptions", FormTypeResolver.getValidOptions());
        return ResponseEntity.unprocessableEntity().body(body);
    }

    @GetMapping(value={"/getFormsByPortalUser/{id}"})
    public ResponseEntity<FormAdminResponseVO> getFormsByPortalUser(@PathVariable Long id) {
        log.info("Fetching forms for portal user ID: {}", (Object)id);
        FormAdminResponseVO response = this.buildFormAdminResponse(id);
        log.debug("Forms retrieved successfully for portal user ID: {}", (Object)id);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/getForms"})
    public ResponseEntity<FormAdminResponseVO> getForms() {
        Authentication a = this.auth();
        if (this.isDM(a)) {
            log.info("DM requesting own forms only");
            Long uid = this.currentUserId(a);
            if (uid == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
            }
            FormAdminResponseVO response = this.buildFormAdminResponse(uid);
            log.info("DM own forms retrieved successfully");
            return ResponseEntity.ok((Object)response);
        }
        log.info("Fetching all forms (Admin/Office)");
        FormAdminResponseVO response = this.buildFormAdminResponseAll();
        log.info("All forms retrieved successfully");
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/getFormsPaginated"})
    public ResponseEntity<?> getFormsPaginated(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size, @RequestParam(defaultValue="submittedDate") String sortBy, @RequestParam(defaultValue="desc") String sortDirection, @RequestParam(name="formName") String formName) {
        Authentication a = this.auth();
        Pageable pageable = this.buildPageable(page, size, sortBy, sortDirection);
        Optional formTypeOpt = FormTypeResolver.resolve((String)formName);
        if (formTypeOpt.isEmpty()) {
            log.warn("Unknown formName '{}'.", (Object)formName);
            return this.buildUnknownFormNameResponse(formName);
        }
        FormTypeResolver.FormType formType = (FormTypeResolver.FormType)formTypeOpt.get();
        if (this.isDM(a)) {
            log.info("DM requesting paginated own forms - page: {}, size: {}, form: {}", new Object[]{page, size, formName});
            Long uid = this.currentUserId(a);
            if (uid == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
            }
            PaginatedFormAdminResponseVO response = this.buildPaginatedResponseByUser(uid, formType, pageable, page, size);
            log.info("DM paginated own '{}' forms retrieved successfully", (Object)formName);
            return ResponseEntity.ok((Object)response);
        }
        log.info("Fetching paginated forms (Admin/Office) - page: {}, size: {}, form: {}", new Object[]{page, size, formName});
        PaginatedFormAdminResponseVO response = this.buildPaginatedResponseAll(formType, pageable, page, size);
        log.info("Paginated '{}' forms retrieved successfully (Admin/Office)", (Object)formName);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<FormCountResponseVO> getFormsCount() {
        Authentication a = this.auth();
        if (!this.isAdminOrOffice(a)) {
            log.warn("Forbidden access to forms count by non-admin/office user: {}", (Object)(a != null ? a.getName() : "anonymous"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        long total = this.formAdminService.countBackPaySubmissions() + this.formAdminService.countBonusSubmissions() + this.formAdminService.countHotelSubmissions() + this.formAdminService.countMileageSubmissions() + this.formAdminService.countPtoSubmissions() + this.formAdminService.countNewHireSubmissions() + this.formAdminService.countPerDiemSubmissions() + this.formAdminService.countTerminationSubmissions() + this.formAdminService.countTargetOrderSubmissions() + this.formAdminService.countUniformSubmissions() + this.formAdminService.countWorkTicketSubmissions() + this.formAdminService.countNonMnMileageSubmissions();
        FormCountResponseVO response = FormCountResponseVO.builder().total(total).build();
        log.info("Forms total count retrieved successfully: {}", (Object)total);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/getFormsPaginatedByPortalUser/{id}"})
    public ResponseEntity<?> getFormsPaginatedByPortalUser(@PathVariable Long id, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size, @RequestParam(defaultValue="submittedDate") String sortBy, @RequestParam(defaultValue="desc") String sortDirection, @RequestParam(name="formName") String formName) {
        Authentication a = this.auth();
        if (!this.isAdminOrOffice(a)) {
            log.warn("Forbidden access to getFormsPaginatedByPortalUser by non-admin/office user: {}", (Object)(a != null ? a.getName() : "anonymous"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        log.info("Fetching paginated forms for portal user ID: {}, page: {}, size: {}, form: {}", new Object[]{id, page, size, formName});
        Optional formTypeOpt = FormTypeResolver.resolve((String)formName);
        if (formTypeOpt.isEmpty()) {
            log.warn("Unknown formName '{}' for getFormsPaginatedByPortalUser.", (Object)formName);
            return this.buildUnknownFormNameResponse(formName);
        }
        Pageable pageable = this.buildPageable(page, size, sortBy, sortDirection);
        PaginatedFormAdminResponseVO response = this.buildPaginatedResponseByUser(id, (FormTypeResolver.FormType)formTypeOpt.get(), pageable, page, size);
        log.info("Paginated '{}' forms for portal user ID {} retrieved successfully", (Object)formName, (Object)id);
        return ResponseEntity.ok((Object)response);
    }

    private Pageable buildPageable(int page, int size, String sortBy, String sortDirection) {
        Sort sort = sortDirection.equalsIgnoreCase("asc") ? Sort.by((String[])new String[]{sortBy}).ascending() : Sort.by((String[])new String[]{sortBy}).descending();
        return PageRequest.of((int)page, (int)size, (Sort)sort);
    }

    private FormAdminResponseVO buildFormAdminResponse(Long userId) {
        FormAdminResponseVO vo = new FormAdminResponseVO();
        vo.setBackPayList(this.formAdminService.getBackPaySubmissionsByUser(userId));
        vo.setBonusList(this.formAdminService.getBonusSubmissionsByUser(userId));
        vo.setHotelList(this.formAdminService.getHotelSubmissionsByUser(userId));
        vo.setMileageList(this.formAdminService.getMileageSubmissionsByUser(userId));
        vo.setPtoList(this.formAdminService.getPtoSubmissionsByUser(userId));
        vo.setNewHireList(this.formAdminService.getNewHireSubmissionsByUser(userId));
        vo.setPerDiemList(this.formAdminService.getPerDiemSubmissionsByUser(userId));
        vo.setTerminationList(this.formAdminService.getTerminationSubmissionsByUser(userId));
        vo.setTargetOrderList(this.formAdminService.getTargetOrderSubmissionsByUser(userId));
        vo.setUniformList(this.formAdminService.getUniformSubmissionsByUser(userId));
        vo.setWorkTicketList(this.formAdminService.getWorkTicketSubmissionsByUser(userId));
        return vo;
    }

    private FormAdminResponseVO buildFormAdminResponseAll() {
        FormAdminResponseVO vo = new FormAdminResponseVO();
        vo.setBackPayList(this.formAdminService.getBackPaySubmissions());
        vo.setBonusList(this.formAdminService.getBonusSubmissions());
        vo.setHotelList(this.formAdminService.getHotelSubmissions());
        vo.setMileageList(this.formAdminService.getMileageSubmissions());
        vo.setPtoList(this.formAdminService.getPtoSubmissions());
        vo.setNewHireList(this.formAdminService.getNewHireSubmissions());
        vo.setPerDiemList(this.formAdminService.getPerDiemSubmissions());
        vo.setTerminationList(this.formAdminService.getTerminationSubmissions());
        vo.setTargetOrderList(this.formAdminService.getTargetOrderSubmissions());
        vo.setUniformList(this.formAdminService.getUniformSubmissions());
        vo.setWorkTicketList(this.formAdminService.getWorkTicketSubmissions());
        return vo;
    }

    private PaginatedFormAdminResponseVO buildPaginatedResponseAll(FormTypeResolver.FormType formType, Pageable pageable, int page, int size) {
        PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder = PaginatedFormAdminResponseVO.builder().currentPage(page).pageSize(size);
        Page selectedPage = this.getPaginatedPage(formType, pageable);
        this.setPageInBuilder(builder, formType, selectedPage);
        this.setPaginationMetadata(builder, selectedPage);
        return builder.build();
    }

    private PaginatedFormAdminResponseVO buildPaginatedResponseByUser(Long userId, FormTypeResolver.FormType formType, Pageable pageable, int page, int size) {
        PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder = PaginatedFormAdminResponseVO.builder().currentPage(page).pageSize(size);
        Page selectedPage = this.getPaginatedPageByUser(userId, formType, pageable);
        this.setPageInBuilder(builder, formType, selectedPage);
        this.setPaginationMetadata(builder, selectedPage);
        return builder.build();
    }

    private Page<?> getPaginatedPage(FormTypeResolver.FormType formType, Pageable pageable) {
        return switch (1.$SwitchMap$com$cbmportal$portal$services$util$FormTypeResolver$FormType[formType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.formAdminService.getBackPaySubmissionsPaginated(pageable);
            case 2 -> this.formAdminService.getBonusSubmissionsPaginated(pageable);
            case 3 -> this.formAdminService.getHotelSubmissionsPaginated(pageable);
            case 4 -> this.formAdminService.getMileageSubmissionsPaginated(pageable);
            case 5 -> this.formAdminService.getPtoSubmissionsPaginated(pageable);
            case 6 -> this.formAdminService.getNewHireSubmissionsPaginated(pageable);
            case 7 -> this.formAdminService.getPerDiemSubmissionsPaginated(pageable);
            case 8 -> this.formAdminService.getTerminationSubmissionsPaginated(pageable);
            case 9 -> this.formAdminService.getTargetOrderSubmissionsPaginated(pageable);
            case 10 -> this.formAdminService.getUniformSubmissionsPaginated(pageable);
            case 11 -> this.formAdminService.getWorkTicketSubmissionsPaginated(pageable);
            case 12 -> this.formAdminService.getNonMnMileageSubmissionsPaginated(pageable);
            case 13 -> this.formAdminService.getTimeAdjustmentSubmissionsPaginated(pageable);
        };
    }

    private Page<?> getPaginatedPageByUser(Long userId, FormTypeResolver.FormType formType, Pageable pageable) {
        return switch (1.$SwitchMap$com$cbmportal$portal$services$util$FormTypeResolver$FormType[formType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.paginate(this.formAdminService.getBackPaySubmissionsByUser(userId), pageable);
            case 2 -> this.paginate(this.formAdminService.getBonusSubmissionsByUser(userId), pageable);
            case 3 -> this.paginate(this.formAdminService.getHotelSubmissionsByUser(userId), pageable);
            case 4 -> this.paginate(this.formAdminService.getMileageSubmissionsByUser(userId), pageable);
            case 5 -> this.paginate(this.formAdminService.getPtoSubmissionsByUser(userId), pageable);
            case 6 -> this.paginate(this.formAdminService.getNewHireSubmissionsByUser(userId), pageable);
            case 7 -> this.paginate(this.formAdminService.getPerDiemSubmissionsByUser(userId), pageable);
            case 8 -> this.paginate(this.formAdminService.getTerminationSubmissionsByUser(userId), pageable);
            case 9 -> this.paginate(this.formAdminService.getTargetOrderSubmissionsByUser(userId), pageable);
            case 10 -> this.paginate(this.formAdminService.getUniformSubmissionsByUser(userId), pageable);
            case 11 -> this.paginate(this.formAdminService.getWorkTicketSubmissionsByUser(userId), pageable);
            case 12 -> this.paginate(this.formAdminService.getNonMnMileageSubmissionsByUser(userId), pageable);
            case 13 -> this.paginate(this.formAdminService.getTimeAdjustmentSubmissionsByUser(userId), pageable);
        };
    }

    private void setPageInBuilder(PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder, FormTypeResolver.FormType formType, Page<?> page) {
        switch (1.$SwitchMap$com$cbmportal$portal$services$util$FormTypeResolver$FormType[formType.ordinal()]) {
            case 1: {
                builder.backPayPage(page);
                break;
            }
            case 2: {
                builder.bonusPage(page);
                break;
            }
            case 3: {
                builder.hotelPage(page);
                break;
            }
            case 4: {
                builder.mileagePage(page);
                break;
            }
            case 5: {
                builder.ptoPage(page);
                break;
            }
            case 6: {
                builder.newHirePage(page);
                break;
            }
            case 7: {
                builder.perDiemPage(page);
                break;
            }
            case 8: {
                builder.terminationPage(page);
                break;
            }
            case 9: {
                builder.targetOrderPage(page);
                break;
            }
            case 10: {
                builder.uniformPage(page);
                break;
            }
            case 11: {
                builder.workTicketPage(page);
                break;
            }
            case 12: {
                builder.nonMnMileagePage(page);
                break;
            }
        }
    }

    private void setPaginationMetadata(PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder, Page<?> page) {
        if (page != null) {
            builder.totalPages(page.getTotalPages()).totalElements(page.getTotalElements()).hasNext(page.hasNext()).hasPrevious(page.hasPrevious());
        } else {
            builder.totalPages(0).totalElements(0L).hasNext(false).hasPrevious(false);
        }
    }
}

