/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.DistrictSafeVO;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.cbmportal.portal.domains.VO.UpdateAuthoritiesRequest;
import com.cbmportal.portal.exceptions.ValidationException;
import com.cbmportal.portal.services.DistrictService;
import com.cbmportal.portal.services.PSService;
import com.cbmportal.portal.services.PortalUserService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin"})
@CrossOrigin
@PreAuthorize(value="hasAnyAuthority('Admin','Office','DM')")
public class AdminController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    private final PortalUserService portalUserService;
    private final PSService psService;
    private final DistrictService districtService;

    public AdminController(PortalUserService portalUserService, PSService psService, DistrictService districtService) {
        this.portalUserService = portalUserService;
        this.psService = psService;
        this.districtService = districtService;
    }

    @GetMapping(value={"/getPortalUsers"})
    public ResponseEntity<List<PortalUser>> getAllPortalUsers() {
        log.info("Fetching all portal users");
        List users = this.portalUserService.getAllPortalUsers();
        log.debug("Retrieved {} portal users", (Object)users.size());
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"/getPortalUser"})
    public ResponseEntity<PortalUser> getPortalUser(@RequestParam(value="userName") String username) {
        this.validateUsername(username);
        log.info("Fetching portal user: {}", (Object)username);
        PortalUser retrievedUser = this.portalUserService.getDm(username);
        log.debug("Portal user retrieved successfully: {}", (Object)username);
        return ResponseEntity.ok((Object)retrievedUser);
    }

    @PostMapping(value={"/createPortalUser"})
    public ResponseEntity<PortalUser> createPortalUser(@RequestBody PortalUser portalUser) {
        this.validatePortalUserForCreate(portalUser);
        log.info("Creating portal user: {}", (Object)portalUser.getUsername());
        PortalUser savedUser = this.portalUserService.createPortalUser(portalUser);
        log.info("Portal user created successfully: {} with permission: {}", (Object)savedUser.getUsername(), (Object)savedUser.getPermission());
        return ResponseEntity.ok((Object)savedUser);
    }

    @PutMapping(value={"/updatePortalUser"})
    public ResponseEntity<PortalUserSafeVO> updatePortalUser(@RequestBody PortalUser portalUser) {
        this.validatePortalUserForUpdate(portalUser);
        log.info("Updating portal user with ID: {}", (Object)portalUser.getId());
        PortalUserSafeVO updatedUser = this.portalUserService.updatePortalUser(portalUser);
        log.info("Portal user updated successfully: {}", (Object)updatedUser.getUserName());
        return ResponseEntity.ok((Object)updatedUser);
    }

    @DeleteMapping(value={"/deletePortalUser/{id}"})
    public ResponseEntity<PortalUser> deletePortalUser(@PathVariable Long id) {
        this.validateId(id, "User ID");
        log.info("Disabling portal user with ID: {}", (Object)id);
        PortalUser disabledUser = this.portalUserService.disablePortalUser(id);
        log.info("Portal user disabled successfully: {} (ID: {})", (Object)disabledUser.getUsername(), (Object)id);
        return ResponseEntity.ok((Object)disabledUser);
    }

    @PostMapping(value={"/assignAuthorities/{id}"})
    public ResponseEntity<PortalUser> assignAuthorities(@PathVariable Long id, @RequestBody UpdateAuthoritiesRequest req) {
        this.validateAuthoritiesRequest(req);
        log.info("Assigning authorities to user ID: {}", (Object)id);
        PortalUser updated = this.portalUserService.assignAuthorities(id, req.getAuthorities());
        log.info("Authorities assigned successfully to user ID: {}", (Object)id);
        return ResponseEntity.ok((Object)updated);
    }

    @PutMapping(value={"/replaceAuthorities/{id}"})
    public ResponseEntity<PortalUser> replaceAuthorities(@PathVariable Long id, @RequestBody UpdateAuthoritiesRequest req) {
        if (req == null || req.getAuthorities() == null) {
            throw new ValidationException("Authorities list is required");
        }
        log.info("Replacing authorities for user ID: {}", (Object)id);
        PortalUser updated = this.portalUserService.replaceAuthorities(id, req.getAuthorities());
        log.info("Authorities replaced successfully for user ID: {}", (Object)id);
        return ResponseEntity.ok((Object)updated);
    }

    @PostMapping(value={"/createPS"})
    public ResponseEntity<PS> createPS(@RequestBody PS ps) {
        this.validatePS(ps);
        log.info("Creating PS: {}", (Object)ps.getFirstName());
        PS savedPS = this.psService.createPS(ps);
        log.info("PS created successfully: {}", (Object)savedPS.getFirstName());
        return ResponseEntity.ok((Object)savedPS);
    }

    @PutMapping(value={"/updatePS"})
    public ResponseEntity<PS> updatePS(@RequestBody PS ps) {
        this.validatePS(ps);
        log.info("Updating PS: {}", (Object)ps.getFirstName());
        PS updatedPS = this.psService.updatePS(ps);
        if (updatedPS.getPortalUser() != null) {
            PortalUserSafeVO portalUserSafeVO = PortalUserSafeVO.fromPortalUser((PortalUser)updatedPS.getPortalUser());
            updatedPS.setUserSafeVO(portalUserSafeVO);
        }
        log.info("PS updated successfully: {}", (Object)updatedPS.getFirstName());
        return ResponseEntity.ok((Object)updatedPS);
    }

    @GetMapping(value={"/districts"})
    public ResponseEntity<List<DistrictSafeVO>> getDistricts() {
        log.info("Fetching all districts");
        List districts = this.districtService.getAllDistrictsSafe();
        log.debug("Retrieved {} districts (safe VO)", (Object)districts.size());
        return ResponseEntity.ok((Object)districts);
    }

    private void validateUsername(String username) {
        if (username == null || username.trim().isEmpty()) {
            log.warn("Request with empty username");
            throw new ValidationException("Username is required");
        }
    }

    private void validateId(Long id, String fieldName) {
        if (id == null) {
            log.warn("Request with null {}", (Object)fieldName);
            throw new ValidationException(fieldName + " is required");
        }
    }

    private void validatePS(PS ps) {
        if (ps == null) {
            log.warn("PS request with null PS data");
            throw new ValidationException("PS data is required");
        }
    }

    private void validateAuthoritiesRequest(UpdateAuthoritiesRequest req) {
        if (req == null || req.getAuthorities() == null || req.getAuthorities().isEmpty()) {
            throw new ValidationException("Authorities list is required");
        }
    }

    private void validatePortalUserForCreate(PortalUser portalUser) {
        if (portalUser == null) {
            throw new ValidationException("Portal user data is required");
        }
        if (portalUser.getUsername() == null || portalUser.getUsername().trim().isEmpty()) {
            throw new ValidationException("Username is required");
        }
        if (!StringUtils.hasText((String)portalUser.getEmail())) {
            throw new ValidationException("Email is required");
        }
    }

    private void validatePortalUserForUpdate(PortalUser portalUser) {
        if (portalUser == null) {
            throw new ValidationException("Portal user data is required");
        }
        if (portalUser.getId() == null) {
            throw new ValidationException("User ID is required for updates");
        }
        if (portalUser.getEmail() != null && !StringUtils.hasText((String)portalUser.getEmail())) {
            throw new ValidationException("Email cannot be blank when provided");
        }
    }
}

