/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class HtmlFragmentBuilder {
    private static final String CELL_STYLE_BASE = "border: 1px solid black; padding: 1px; text-align: left;";

    public String div(String cssClass, String content) {
        return String.format("<div class=\"%s\">%s</div>", cssClass, this.escapeHtml(content));
    }

    public String divWithStyle(String style, String content) {
        return String.format("<div style=\"%s\">%s</div>", style, this.escapeHtml(content));
    }

    public String tableCell(String widthPercent, String content) {
        String style = String.format("width: %s; %s", widthPercent, CELL_STYLE_BASE);
        return this.divWithStyle(style, content);
    }

    public String signatureImage(String base64Data, String altText) {
        if (base64Data == null || base64Data.isBlank()) {
            return "";
        }
        return "<img src=" + base64Data + " alt=\"" + this.escapeHtml(altText) + "\" />";
    }

    public String row(String cssClass, String ... children) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<div class=\"%s\">", cssClass));
        for (String child : children) {
            sb.append(child);
        }
        sb.append("</div>");
        return sb.toString();
    }

    public String backPayRow(LocalDate date, LocalDateTime punchIn, LocalDateTime punchOut, LocalDateTime leftLunch, LocalDateTime returnLunch, BigDecimal netHours, DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"backPayInfoContainer\">");
        row.append(this.tableCell("13%", dateFormatter.format(date)));
        row.append(this.tableCell("15%", timeFormatter.format(punchIn)));
        if (leftLunch == null || returnLunch == null) {
            row.append(this.tableCell("22%", "No Time"));
            row.append(this.tableCell("21%", "No Time"));
        } else {
            row.append(this.tableCell("21%", timeFormatter.format(leftLunch)));
            row.append(this.tableCell("22%", timeFormatter.format(returnLunch)));
        }
        row.append(this.tableCell("13%", timeFormatter.format(punchOut)));
        row.append(this.tableCell("12%", netHours.toPlainString() + " hrs"));
        row.append("</div>");
        return row.toString();
    }

    public String mileageRow(LocalDate date, String startLocation, String endLocation, DateTimeFormatter dateFormatter) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"mileageInfoContainer\" style=\"display: flex; width: 100%;\">");
        row.append(this.tableCell("20%", dateFormatter.format(date)));
        row.append(this.tableCell("38.5%", startLocation));
        row.append(this.tableCell("38.5%", endLocation));
        row.append("</div>");
        return row.toString();
    }

    public String mileageRowWithRtOw(LocalDate date, String startLocation, String endLocation, String rtOw, DateTimeFormatter dateFormatter) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"mileageInfoContainer\" style=\"display: flex; width: 100%;\">");
        row.append(this.tableCell("20%", dateFormatter.format(date)));
        row.append(this.tableCell("32.5%", startLocation));
        row.append(this.tableCell("32.5%", endLocation));
        row.append(this.tableCell("10%", rtOw != null ? rtOw : ""));
        row.append("</div>");
        return row.toString();
    }

    public String perDiemMileage(LocalDate date, String startLocation, String endLocation, String rtOw, DateTimeFormatter dateFormatter) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"mileageInfoContainer\" style=\"display: flex; width: 100%;\">");
        row.append(this.tableCell("11%", dateFormatter.format(date)));
        row.append(this.tableCell("29%", startLocation));
        row.append(this.tableCell("29%", endLocation));
        row.append(this.tableCell("9.5%", rtOw != null ? rtOw : ""));
        row.append("</div>");
        return row.toString();
    }

    public String bonusRow(LocalDate date, String storeInfo, String bonusAmount, DateTimeFormatter dateFormatter) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"bonusInfoContainer\" style=\"display: flex; width: 100%;\">");
        row.append(this.tableCell("15%", dateFormatter.format(date)));
        row.append(this.tableCell("69%", storeInfo));
        row.append(this.tableCell("15%", bonusAmount));
        row.append("</div>");
        return row.toString();
    }

    public String targetOrderItemRow(String itemName, int quantity) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"item-name\"><p>").append(this.escapeHtml(itemName)).append("</p></div>");
        row.append("<div class=\"item-quantity\"><p>").append(quantity).append("</p></div>");
        return row.toString();
    }

    public String timeAdjustmentRow(LocalDate date, LocalDateTime punchIn, LocalDateTime punchOut, long totalHours, double breakAmount, double adjustedHours, DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter) {
        StringBuilder row = new StringBuilder();
        row.append("<div class=\"timeAdjustContainer\" style=\"display: flex; width: 100%;\">");
        row.append(this.tableCell("17%", dateFormatter.format(date)));
        row.append(this.tableCell("17%", timeFormatter.format(punchIn)));
        row.append(this.tableCell("17%", timeFormatter.format(punchOut)));
        row.append(this.tableCell("16%", totalHours + " hrs"));
        row.append(this.tableCell("16%", breakAmount + " hrs"));
        row.append(this.tableCell("17%", adjustedHours + " hrs"));
        row.append("</div>");
        return row.toString();
    }

    public String emailBody(String formTitle, Map<String, String> details) {
        StringBuilder body = new StringBuilder();
        body.append("<html><body>");
        body.append("<h3>").append(this.escapeHtml(formTitle)).append(" Submission</h3>");
        for (Map.Entry<String, String> entry : details.entrySet()) {
            if ("Employee".equals(entry.getKey()) || "Store".equals(entry.getKey())) {
                body.append("<p>").append(this.escapeHtml(entry.getKey())).append(": <strong>").append(this.escapeHtml(entry.getValue())).append("</strong></p>");
                continue;
            }
            body.append("<p>").append(this.escapeHtml(entry.getKey())).append(": ").append(this.escapeHtml(entry.getValue())).append("</p>");
        }
        body.append("</body></html>");
        return body.toString();
    }

    public String simpleEmailBody(String formTitle, String employeeName, String employeeNumber) {
        return this.emailBody(formTitle, Map.of("Employee", employeeName, "Employee Number", employeeNumber));
    }

    public String emailBodyWithStore(String formTitle, String employeeName, String employeeNumber, String storeInfo) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("Employee", employeeName);
        details.put("Employee Number", employeeNumber);
        details.put("Store", storeInfo);
        return this.emailBody(formTitle, details);
    }

    public String escapeHtml(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;");
    }

    public String formatDate(LocalDate date, DateTimeFormatter formatter) {
        return date != null ? formatter.format(date) : "";
    }

    public String formatDateTime(LocalDateTime dateTime, DateTimeFormatter formatter) {
        return dateTime != null ? formatter.format(dateTime) : "";
    }

    public String valueOrDefault(String value, String defaultValue) {
        return value == null || value.isBlank() ? defaultValue : value;
    }
}

