/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.WorkTicketRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.WorkTicketService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.DepartmentEmailHelper;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class WorkTicketServiceImpl
implements WorkTicketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkTicketServiceImpl.class);
    private final WorkTicketRepository workTicketRepository;
    private final MicrosoftGraphEmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final PdfStorageHelper pdfStorageHelper;
    private final DepartmentEmailHelper emailHelper;
    private final HtmlFragmentBuilder htmlBuilder;
    private final String htmlFormLocation;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-yyyy");

    public WorkTicketServiceImpl(WorkTicketRepository workTicketRepository, MicrosoftGraphEmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, DepartmentEmailHelper emailHelper, HtmlFragmentBuilder htmlBuilder) {
        this.workTicketRepository = workTicketRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
        this.emailHelper = emailHelper;
        this.htmlBuilder = htmlBuilder;
    }

    public FormSubmissionResponse processWorkTicket(WorkTicket wt, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        FormContext context = this.buildFormContext(wt);
        try {
            Document doc = this.generateHtmlDocument(context, wt);
            File pdfFile = new File(context.getPdfSaveLocation() + context.getPdfFileName());
            log.info("Generating PDF at: {}", (Object)pdfFile.getPath());
            this.pdfBuilderService.generatePdf(context.getPdfSaveLocation(), context.getPdfFileName(), doc);
            if (pdfFile.exists() && !pdfFile.isDirectory()) {
                log.info("{} was created successfully.", (Object)context.getPdfFileName());
                this.sendEmailNotification(context, pdfFile);
                response.setStatus(HttpStatus.OK.value());
                wt.setSubmittedDate(LocalDateTime.now());
                WorkTicket savedWT = (WorkTicket)this.workTicketRepository.save((Object)wt);
                if (savedWT.getId() != null) {
                    formResponse.setFormName("Work Ticket");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException exc) {
            log.error("Error processing work ticket", exc);
            formResponse.setFormName("Work Ticket");
            formResponse.setSuccess(false);
            formResponse.setApiError(this.buildApiError((Exception)exc));
        }
        return formResponse;
    }

    private FormContext buildFormContext(WorkTicket wt) throws IOException {
        String fullEmployeeName = wt.getEmployee().getEmployeeFirst() + " " + wt.getEmployee().getEmployeeLast();
        String empNum = wt.getEmployee().getEmployeeNumber().toString();
        String financeEmail = this.emailHelper.getEmail("Finance", "Work Ticket");
        String base = this.customProperties.getPdfFiles();
        if (base == null || base.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, new String[]{"wt", empNum});
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("Employee", fullEmployeeName);
        details.put("Employee Number", empNum);
        details.put("Current Location", wt.getCurrentLocation().getStoreNum() + " " + wt.getCurrentLocation().getName());
        details.put("Project Location", wt.getProjectLocation().getStoreNum() + " " + wt.getProjectLocation().getName());
        return FormContext.builder().employee(wt.getEmployee()).pdfFileName("wt-" + empNum + "-" + LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() + ".pdf").pdfSaveLocation(pdfSaveLocation).recipients(List.of(financeEmail, wt.getPortalUser().getEmail())).emailSubject("Work Ticket - " + fullEmployeeName).emailBody(this.htmlBuilder.emailBody("Work Ticket", details)).portalUserName(wt.getPortalUser().getUserFirst() + " " + wt.getPortalUser().getUserLast()).formType("WORK_TICKET").build();
    }

    private Document generateHtmlDocument(FormContext context, WorkTicket wt) throws IOException {
        File wtHtml = new File(this.htmlFormLocation + "workticket.html");
        Document doc = Jsoup.parse((File)wtHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("currentLocation").html(wt.getCurrentLocation().getStoreNum() + " " + wt.getCurrentLocation().getName());
        doc.getElementsByClass("city").html(wt.getCurrentLocation().getCity());
        doc.getElementsByClass("state").html(wt.getCurrentLocation().getState());
        doc.getElementsByClass("projectStoreName").html(wt.getProjectLocation().getStoreNum() + " " + wt.getProjectLocation().getName());
        doc.getElementsByClass("projectStoreCity").html(wt.getProjectLocation().getCity());
        doc.getElementsByClass("projectStoreState").html(wt.getProjectLocation().getState());
        doc.getElementsByClass("typeOfWork").html(wt.getTypeOfWork().getTypeOfWork());
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeName").html(context.getEmployee().getEmployeeFirst() + " " + context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("notes").html(this.htmlBuilder.valueOrDefault(wt.getNotes(), ""));
        doc.getElementsByClass("equipmentNeeded").html(this.htmlBuilder.valueOrDefault(wt.getEquipmentNeeded(), ""));
        doc.getElementsByClass("isBillable").html(this.htmlBuilder.valueOrDefault(wt.getIsBillable(), ""));
        doc.getElementsByClass("orderSubmitted").html(Boolean.TRUE.equals(wt.getSupplyOrderSubmitted()) ? "Yes" : "No");
        doc.getElementsByClass("orderNumber").html(this.htmlBuilder.valueOrDefault(wt.getOrderNumber(), ""));
        doc.getElementsByClass("supplyOrderDate").html(wt.getSupplyOrderDate() != null ? this.dateFormatter.format(wt.getSupplyOrderDate()) : "");
        doc.getElementsByClass("projectStartDate").html(wt.getProjectStartDate() != null ? this.dateFormatter.format(wt.getProjectStartDate()) : "");
        doc.getElementsByClass("projectEndDate").html(wt.getProjectEndDate() != null ? this.dateFormatter.format(wt.getProjectEndDate()) : "");
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    private void sendEmailNotification(FormContext context, File pdfFile) {
        this.emailService.sendEmail(context.getRecipients(), context.getEmailSubject(), context.getEmailBody(), pdfFile);
    }

    private ApiError buildApiError(Exception exc) {
        ApiError error = new ApiError();
        error.setApiName("/finance/workTicketSubmit");
        error.setErrorMessage(exc.getMessage());
        error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        return error;
    }
}

