/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.TerminationRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TerminationService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.HtmlFragmentBuilder;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TerminationServiceImpl
extends AbstractFormProcessingService<Termination>
implements TerminationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerminationServiceImpl.class);
    private final HtmlFragmentBuilder htmlBuilder;

    public TerminationServiceImpl(TerminationRepository terminationRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper, HtmlFragmentBuilder htmlBuilder) {
        super(pdfBuilderService, emailService, (JpaRepository)terminationRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.htmlBuilder = htmlBuilder;
    }

    public FormSubmissionResponse processTermination(Termination termination) {
        return this.processForm((Object)termination);
    }

    protected void validateFormData(Termination termination) {
        if (termination == null) {
            throw new FormProcessingException("Termination data cannot be null");
        }
        if (termination.getEmployee() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (termination.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee number is required");
        }
        if (termination.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (termination.getTermType() == null) {
            throw new FormProcessingException("Termination type is required");
        }
        if (termination.getLastDayWorked() == null) {
            throw new FormProcessingException("Last day worked is required");
        }
        if (termination.getEligibleRehire() == null) {
            throw new FormProcessingException("Eligible for rehire status is required");
        }
        if (termination.getQuitReason() == null) {
            throw new FormProcessingException("Quit reason is required");
        }
        if (termination.getTwoWeeksGiven() == null) {
            throw new FormProcessingException("Two weeks given status is required");
        }
        if (termination.getWarningsGiven() == null) {
            throw new FormProcessingException("Warnings given status is required");
        }
    }

    protected FormContext buildFormContext(Termination termination) {
        String fullEmployeeName = termination.getEmployee().getEmployeeFirst() + " " + termination.getEmployee().getEmployeeLast();
        String empNum = termination.getEmployee().getEmployeeNumber().toString();
        String currentDate = this.dateFormatter.format(LocalDate.now());
        String termEmail = this.getDepartmentEmail("Terminations", "Termination");
        return FormContext.builder().employee(termination.getEmployee()).pdfFileName("termination-" + empNum + "-" + currentDate + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"termination", empNum})).recipients(List.of(termEmail, termination.getPortalUser().getEmail())).emailSubject("Termination Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum, termination)).portalUserName(termination.getPortalUser().getUserFirst() + " " + termination.getPortalUser().getUserLast()).formType("TERMINATION").build();
    }

    protected Document generateHtmlDocument(FormContext context, Termination termination) throws IOException {
        File terminationHtml = new File(this.htmlFormLocation + "termination.html");
        Document doc = Jsoup.parse((File)terminationHtml, (String)"UTF-8", (String)"");
        TerminationServiceImpl.wereWarningsGiven((Termination)termination, (Document)doc);
        TerminationServiceImpl.wasTwoWeeksGiven((Termination)termination, (Document)doc);
        TerminationServiceImpl.isEligibleForRehire((Termination)termination, (Document)doc);
        TerminationServiceImpl.didNoShowFirstDay((Termination)termination, (Document)doc);
        doc.getElementsByClass("employeeNum").html(String.valueOf(context.getEmployee().getEmployeeNumber()));
        doc.getElementsByClass("employeeFirstName").html(context.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeLastName").html(context.getEmployee().getEmployeeLast());
        doc.getElementsByClass("employeeSecondLastName").html(context.getEmployee().getEmployeeSecondLast() != null ? context.getEmployee().getEmployeeSecondLast() : "");
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("lastDayWorked").html(this.dateFormatter.format(termination.getLastDayWorked()));
        doc.getElementsByClass("termType").html(termination.getTermType().getTermType());
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Termination Form";
    }

    protected Long getEntityId(Termination entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(Termination termination) {
        termination.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber, Termination termination) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("Employee", employeeName);
        details.put("Employee Number", employeeNumber);
        details.put("Last Day Worked", this.dateFormatter.format(termination.getLastDayWorked()));
        return this.htmlBuilder.emailBody("Termination Form", details);
    }

    private static void didNoShowFirstDay(Termination termination, Document doc) {
        if (!Objects.equals(termination.getTermType().toString(), "noShowFirstDay")) {
            doc.getElementsByClass("quitReason").html("<td>Reason employee quit: " + termination.getQuitReason() + "</td>");
        } else {
            doc.getElementsByClass("quitReason").html("<td>Reason employee quit: N/A</td>");
        }
    }

    private static void wereWarningsGiven(Termination termination, Document doc) {
        if (Objects.equals(termination.getTermType().toString(), "Other")) {
            if (termination.getWarningsGiven().booleanValue()) {
                doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">Yes</span> ");
            } else {
                doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">No</span> ");
            }
        } else {
            doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">N/A</span> ");
        }
    }

    private static void wasTwoWeeksGiven(Termination termination, Document doc) {
        if (Objects.equals(termination.getTermType().toString(), "twoWeeks")) {
            if (termination.getTwoWeeksGiven().booleanValue()) {
                doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">Yes</span> </td>");
            } else {
                doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">No</span> </td>");
            }
        } else {
            doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">N/A</span> </td>");
        }
    }

    private static void isEligibleForRehire(Termination termination, Document doc) {
        if (termination.getEligibleRehire().booleanValue()) {
            doc.getElementsByClass("eligibleRehire").html("Eligible for rehire: Yes");
        } else {
            doc.getElementsByClass("eligibleRehire").html("Eligible for rehire: No");
        }
    }
}

