/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.BackPayDate;
import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
public class BackPay {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="backPay_id_seq")
    @SequenceGenerator(name="backPay_id_seq", sequenceName="back_pay_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser = null;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private Store store = null;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<BackPayDate> backPayDates = null;
    @JsonProperty
    private String payMissed = null;
    @Column(length=2000)
    @JdbcTypeCode(value=12)
    @JsonProperty
    private String sig = null;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackPay backPay = (BackPay)o;
        return Objects.equals(this.id, backPay.id) && Objects.equals(this.portalUser, backPay.portalUser) && Objects.equals(this.employee, backPay.employee) && Objects.equals(this.store, backPay.store) && Objects.equals(this.backPayDates, backPay.backPayDates) && Objects.equals(this.payMissed, backPay.payMissed) && Objects.equals(this.sig, backPay.sig) && Objects.equals(this.apiError, backPay.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.portalUser, this.employee, this.store, this.backPayDates, this.payMissed, this.sig, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", BackPay.class.getSimpleName() + "[", "]").add("id=" + this.id).add("portalUser=" + String.valueOf(this.portalUser)).add("employee=" + String.valueOf(this.employee)).add("store=" + String.valueOf(this.store)).add("backPayDates=" + String.valueOf(this.backPayDates)).add("payMissed='" + this.payMissed + "'").add("sig='" + this.sig + "'").add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    @Generated
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    @Generated
    public void setBackPayDates(List<BackPayDate> backPayDates) {
        this.backPayDates = backPayDates;
    }

    @JsonProperty
    @Generated
    public void setPayMissed(String payMissed) {
        this.payMissed = payMissed;
    }

    @JsonProperty
    @Generated
    public void setSig(String sig) {
        this.sig = sig;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public Employee getEmployee() {
        return this.employee;
    }

    @Generated
    public Store getStore() {
        return this.store;
    }

    @Generated
    public List<BackPayDate> getBackPayDates() {
        return this.backPayDates;
    }

    @Generated
    public String getPayMissed() {
        return this.payMissed;
    }

    @Generated
    public String getSig() {
        return this.sig;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

