/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Mileage {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="mileage_id_seq")
    @SequenceGenerator(name="mileage_id_seq", sequenceName="mileage_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private String comments = "";
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<MileageDate> mileageDates;
    @JsonProperty
    private LocalDateTime submittedDate = null;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public Mileage(String comments, List<MileageDate> mileageDates, ApiError apiError) {
        this.comments = comments;
        this.mileageDates = mileageDates;
        this.apiError = apiError;
    }

    public Mileage() {
    }

    public Mileage(String comments, Employee employee, PortalUser portalUser, List<MileageDate> mileageDates, ApiError apiError) {
        this.comments = comments;
        this.employee = employee;
        this.portalUser = portalUser;
        this.mileageDates = mileageDates;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mileage mileage = (Mileage)o;
        return Objects.equals(this.id, mileage.id) && Objects.equals(this.comments, mileage.comments) && Objects.equals(this.employee, mileage.employee) && Objects.equals(this.portalUser, mileage.portalUser) && Objects.equals(this.mileageDates, mileage.mileageDates) && Objects.equals(this.apiError, mileage.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", Mileage.class.getSimpleName() + "[", "]").add("id=" + this.id).add("comments='" + this.comments + "'").add("employee=" + String.valueOf(this.employee)).add("portalUser=" + String.valueOf(this.portalUser)).add("mileageDates=" + String.valueOf(this.mileageDates)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.comments, this.employee, this.portalUser, this.mileageDates, this.apiError);
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    @Generated
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setMileageDates(List<MileageDate> mileageDates) {
        this.mileageDates = mileageDates;
    }

    @JsonProperty
    @Generated
    public void setSubmittedDate(LocalDateTime submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public Employee getEmployee() {
        return this.employee;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public List<MileageDate> getMileageDates() {
        return this.mileageDates;
    }

    @Generated
    public LocalDateTime getSubmittedDate() {
        return this.submittedDate;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

