/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.exceptions.ResourceNotFoundException;
import com.cbmportal.portal.services.StoreService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/api/stores/v1"})
public class StoreController {
    private final Logger log = LoggerFactory.getLogger(StoreController.class);
    private final StoreService storeService;

    public StoreController(StoreService storeService) {
        this.storeService = storeService;
    }

    @GetMapping(value={"/getStores"})
    public ResponseEntity<List<Store>> getStores() {
        this.log.debug("Fetching all active stores");
        ArrayList<Store> stores = new ArrayList<Store>();
        this.storeService.getStores().iterator().forEachRemaining(stores::add);
        stores.removeIf(store -> store.getDisabled() != null && store.getDisabled() != false);
        if (stores.isEmpty()) {
            this.log.warn("No active stores found");
            throw new ResourceNotFoundException("No stores found");
        }
        this.log.info("Retrieved {} active stores", (Object)stores.size());
        return ResponseEntity.ok().body(stores);
    }

    @PostMapping
    @RequestMapping(value={"/createStore"})
    public ResponseEntity<Store> createStore(@RequestBody Store store, HttpServletResponse response) {
        Store savedStore = this.storeService.createDistrictStore(store);
        return ResponseEntity.ok().body((Object)savedStore);
    }

    @PostMapping(value={"/getDistrictStores"})
    public ResponseEntity<List<Store>> getStoresByDistrict(@RequestBody List<District> districtList) {
        this.log.debug("Fetching stores for {} districts", (Object)districtList.size());
        ArrayList<Store> stores = new ArrayList<Store>();
        try {
            for (District district : districtList) {
                this.storeService.getStoresByDistrict(district).iterator().forEachRemaining(stores::add);
            }
            stores.removeIf(store -> store.getDisabled() != null && store.getDisabled() != false);
            if (!stores.isEmpty()) {
                stores.sort(Comparator.comparing(Store::getBanner).thenComparing(Store::getStoreNum));
                this.log.info("Retrieved {} active stores for districts", (Object)stores.size());
                return ResponseEntity.ok().body(stores);
            }
            this.log.warn("No active stores found for provided districts");
            throw new ResourceNotFoundException("No stores found");
        }
        catch (NullPointerException | HttpClientErrorException.BadRequest nullPointerException) {
            this.log.error("Error fetching stores by district", nullPointerException);
            return ResponseEntity.internalServerError().body(new ArrayList());
        }
    }

    @PutMapping(value={"/updateStore"})
    ResponseEntity<Store> updateStore(@RequestBody Store store) {
        return ResponseEntity.ok().body((Object)this.storeService.updateStore(store));
    }

    @DeleteMapping(value={"/deleteStore/{id}"})
    public ResponseEntity<Store> deleteStore(@PathVariable Long id) {
        this.log.info("Disabling store with ID: {}", (Object)id);
        Store disabledStore = this.storeService.disableStore(id);
        this.log.info("Store disabled successfully: {} (ID: {})", (Object)disabledStore.getStoreNum(), (Object)id);
        return ResponseEntity.ok((Object)disabledStore);
    }
}

