/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl.admin;

import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.BackpayRepository;
import com.cbmportal.portal.repositories.BonusRepository;
import com.cbmportal.portal.repositories.HotelRepository;
import com.cbmportal.portal.repositories.MileageRepository;
import com.cbmportal.portal.repositories.NewHireRepository;
import com.cbmportal.portal.repositories.NonMnMileageRepository;
import com.cbmportal.portal.repositories.PerDiemRepository;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.PtoRepository;
import com.cbmportal.portal.repositories.TargetOrderRepository;
import com.cbmportal.portal.repositories.TerminationRepository;
import com.cbmportal.portal.repositories.TimeAdjustmentRepository;
import com.cbmportal.portal.repositories.UniformRepository;
import com.cbmportal.portal.repositories.WorkTicketRepository;
import com.cbmportal.portal.services.admin.FormAdminService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class FormAdminServiceImpl
implements FormAdminService {
    private final BackpayRepository backpayRepository;
    private final BonusRepository bonusRepository;
    private final HotelRepository hotelRepository;
    private final MileageRepository mileageRepository;
    private final NewHireRepository newHireRepository;
    private final NonMnMileageRepository nonMnMileageRepository;
    private final PerDiemRepository perDiemRepository;
    private final PtoRepository ptoRepository;
    private final TargetOrderRepository targetOrderRepository;
    private final TerminationRepository terminationRepository;
    private final TimeAdjustmentRepository timeAdjustmentRepository;
    private final UniformRepository uniformRepository;
    private final WorkTicketRepository workTicketRepository;
    private final PortalUserRepository portalUserRepository;

    public FormAdminServiceImpl(BackpayRepository backpayRepository, BonusRepository bonusRepository, HotelRepository hotelRepository, MileageRepository mileageRepository, NewHireRepository newHireRepository, NonMnMileageRepository nonMnMileageRepository, PerDiemRepository perDiemRepository, PtoRepository ptoRepository, TargetOrderRepository targetOrderRepository, TerminationRepository terminationRepository, TimeAdjustmentRepository timeAdjustmentRepository, UniformRepository uniformRepository, WorkTicketRepository workTicketRepository, PortalUserRepository portalUserRepository) {
        this.backpayRepository = backpayRepository;
        this.bonusRepository = bonusRepository;
        this.hotelRepository = hotelRepository;
        this.mileageRepository = mileageRepository;
        this.newHireRepository = newHireRepository;
        this.nonMnMileageRepository = nonMnMileageRepository;
        this.perDiemRepository = perDiemRepository;
        this.ptoRepository = ptoRepository;
        this.targetOrderRepository = targetOrderRepository;
        this.terminationRepository = terminationRepository;
        this.timeAdjustmentRepository = timeAdjustmentRepository;
        this.uniformRepository = uniformRepository;
        this.workTicketRepository = workTicketRepository;
        this.portalUserRepository = portalUserRepository;
    }

    private Authentication auth() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isAdminOrOffice() {
        Authentication a = this.auth();
        if (a == null) {
            return false;
        }
        Set roles = a.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        return roles.contains("Admin") || roles.contains("Office");
    }

    private boolean isDM() {
        Authentication a = this.auth();
        if (a == null) {
            return false;
        }
        return a.getAuthorities().stream().anyMatch(ga -> "DM".equals(ga.getAuthority()));
    }

    private Long currentUserId() {
        Authentication a = this.auth();
        if (a == null) {
            return null;
        }
        String username = a.getName();
        return this.portalUserRepository.findByUserNameAndDisabledFalse(username).map(PortalUser::getId).orElse(null);
    }

    private Set<Long> currentUserDistrictIds() {
        Authentication a = this.auth();
        if (a == null) {
            return Collections.emptySet();
        }
        String username = a.getName();
        return this.portalUserRepository.findByUserNameAndDisabledFalse(username).map(u -> u.getDistrict() == null ? Collections.emptySet() : u.getDistrict().stream().map(d -> d.getId()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    private boolean inDistrict(Store store, Set<Long> allowedDistrictIds) {
        if (store == null || store.getDistrict() == null || store.getDistrict().getId() == null) {
            return false;
        }
        return allowedDistrictIds.contains(store.getDistrict().getId());
    }

    public List<BackPay> getBackPaySubmissions() {
        ArrayList<BackPay> all = new ArrayList<BackPay>();
        this.backpayRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(b -> b.getPortalUser() != null && b.getPortalUser().getId().equals(uid) || this.inDistrict(b.getStore(), districtIds)).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(b -> b.getPortalUser() != null && b.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<Bonus> getBonusSubmissions() {
        ArrayList<Bonus> all = new ArrayList<Bonus>();
        this.bonusRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(b -> b.getPortalUser() != null && b.getPortalUser().getId().equals(uid) || b.getBonuses() != null && b.getBonuses().stream().anyMatch(bd -> this.inDistrict(bd.getStore(), districtIds))).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(b -> b.getPortalUser() != null && b.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<Hotel> getHotelSubmissions() {
        ArrayList<Hotel> all = new ArrayList<Hotel>();
        this.hotelRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(h -> h.getPortalUser() != null && h.getPortalUser().getId().equals(uid) || this.inDistrict(h.getStore(), districtIds)).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(h -> h.getPortalUser() != null && h.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<Mileage> getMileageSubmissions() {
        ArrayList<Mileage> all = new ArrayList<Mileage>();
        this.mileageRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(m -> m.getPortalUser() != null && m.getPortalUser().getId().equals(uid) || m.getMileageDates() != null && m.getMileageDates().stream().anyMatch(md -> this.inDistrict(md.getLocation1(), districtIds) || this.inDistrict(md.getLocation2(), districtIds))).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(m -> m.getPortalUser() != null && m.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<NewHire> getNewHireSubmissions() {
        ArrayList<NewHire> all = new ArrayList<NewHire>();
        this.newHireRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(n -> n.getPortalUser() != null && n.getPortalUser().getId().equals(uid) || this.inDistrict(n.getStore(), districtIds)).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(n -> n.getPortalUser() != null && n.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<NonMnMileage> getNonMnMileageSubmissions() {
        ArrayList<NonMnMileage> all = new ArrayList<NonMnMileage>();
        this.nonMnMileageRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(m -> m.getPortalUser() != null && m.getPortalUser().getId().equals(uid) || m.getMileageDates() != null && m.getMileageDates().stream().anyMatch(md -> this.inDistrict(md.getLocation1(), districtIds) || this.inDistrict(md.getLocation2(), districtIds))).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(m -> m.getPortalUser() != null && m.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<PerDiem> getPerDiemSubmissions() {
        ArrayList<PerDiem> all = new ArrayList<PerDiem>();
        this.perDiemRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(p -> p.getPortalUser() != null && p.getPortalUser().getId().equals(uid) || this.inDistrict(p.getStore(), districtIds)).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(p -> p.getPortalUser() != null && p.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<Pto> getPtoSubmissions() {
        ArrayList<Pto> all = new ArrayList<Pto>();
        this.ptoRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        Long uid = this.currentUserId();
        return all.stream().filter(p -> p.getPortalUser() != null && p.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<TargetOrder> getTargetOrderSubmissions() {
        ArrayList<TargetOrder> all = new ArrayList<TargetOrder>();
        this.targetOrderRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(t -> t.getPortalUser() != null && t.getPortalUser().getId().equals(uid) || this.inDistrict(t.getStore(), districtIds)).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(t -> t.getPortalUser() != null && t.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<Termination> getTerminationSubmissions() {
        ArrayList<Termination> all = new ArrayList<Termination>();
        this.terminationRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        Long uid = this.currentUserId();
        return all.stream().filter(t -> t.getPortalUser() != null && t.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<TimeAdjustment> getTimeAdjustmentSubmissions() {
        ArrayList<TimeAdjustment> all = new ArrayList<TimeAdjustment>();
        this.timeAdjustmentRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        Long uid = this.currentUserId();
        return all.stream().filter(t -> t.getPortalUser() != null && t.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<Uniform> getUniformSubmissions() {
        ArrayList<Uniform> all = new ArrayList<Uniform>();
        this.uniformRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        Long uid = this.currentUserId();
        return all.stream().filter(u -> u.getPortalUser() != null && u.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    public List<WorkTicket> getWorkTicketSubmissions() {
        ArrayList<WorkTicket> all = new ArrayList<WorkTicket>();
        this.workTicketRepository.findAll().forEach(all::add);
        if (this.isAdminOrOffice()) {
            return all;
        }
        if (this.isDM()) {
            Set districtIds = this.currentUserDistrictIds();
            Long uid = this.currentUserId();
            return all.stream().filter(w -> w.getPortalUser() != null && w.getPortalUser().getId().equals(uid) || this.inDistrict(w.getCurrentLocation(), districtIds) || this.inDistrict(w.getProjectLocation(), districtIds)).collect(Collectors.toList());
        }
        Long uid = this.currentUserId();
        return all.stream().filter(w -> w.getPortalUser() != null && w.getPortalUser().getId().equals(uid)).collect(Collectors.toList());
    }

    private <E> Page<E> paginate(List<E> items, Pageable pageable) {
        int total = items.size();
        int start = (int)Math.min(pageable.getOffset(), (long)total);
        int end = Math.min(start + pageable.getPageSize(), total);
        List<E> content = items.subList(start, end);
        return new PageImpl(content, pageable, (long)total);
    }

    public Page<BackPay> getBackPaySubmissionsPaginated(Pageable pageable) {
        Page page = this.backpayRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getBackPaySubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<Bonus> getBonusSubmissionsPaginated(Pageable pageable) {
        Page page = this.bonusRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getBonusSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<Hotel> getHotelSubmissionsPaginated(Pageable pageable) {
        Page page = this.hotelRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getHotelSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<Mileage> getMileageSubmissionsPaginated(Pageable pageable) {
        Page page = this.mileageRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getMileageSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<NewHire> getNewHireSubmissionsPaginated(Pageable pageable) {
        Page page = this.newHireRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getNewHireSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<NonMnMileage> getNonMnMileageSubmissionsPaginated(Pageable pageable) {
        Page page = this.nonMnMileageRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getNonMnMileageSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<PerDiem> getPerDiemSubmissionsPaginated(Pageable pageable) {
        Page page = this.perDiemRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getPerDiemSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<Pto> getPtoSubmissionsPaginated(Pageable pageable) {
        Page page = this.ptoRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getPtoSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<TargetOrder> getTargetOrderSubmissionsPaginated(Pageable pageable) {
        Page page = this.targetOrderRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getTargetOrderSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<Termination> getTerminationSubmissionsPaginated(Pageable pageable) {
        Page page = this.terminationRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getTerminationSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<TimeAdjustment> getTimeAdjustmentSubmissionsPaginated(Pageable pageable) {
        Page page = this.timeAdjustmentRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getTimeAdjustmentSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<Uniform> getUniformSubmissionsPaginated(Pageable pageable) {
        Page page = this.uniformRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getUniformSubmissions();
        return this.paginate(filtered, pageable);
    }

    public Page<WorkTicket> getWorkTicketSubmissionsPaginated(Pageable pageable) {
        Page page = this.workTicketRepository.findAll(pageable);
        if (this.isAdminOrOffice()) {
            return page;
        }
        List filtered = this.getWorkTicketSubmissions();
        return this.paginate(filtered, pageable);
    }

    public List<BackPay> getBackPaySubmissionsByUser(Long userId) {
        return this.backpayRepository.findByPortalUserId(userId);
    }

    public List<Bonus> getBonusSubmissionsByUser(Long userId) {
        return this.bonusRepository.findByPortalUserId(userId);
    }

    public List<Hotel> getHotelSubmissionsByUser(Long userId) {
        return this.hotelRepository.findAllByPortalUserId(userId);
    }

    public List<Mileage> getMileageSubmissionsByUser(Long userId) {
        return this.mileageRepository.findByPortalUserId(userId);
    }

    public List<NewHire> getNewHireSubmissionsByUser(Long userId) {
        return this.newHireRepository.findAllByPortalUserId(userId);
    }

    public List<NonMnMileage> getNonMnMileageSubmissionsByUser(Long userId) {
        return this.nonMnMileageRepository.findByPortalUserId(userId);
    }

    public List<PerDiem> getPerDiemSubmissionsByUser(Long userId) {
        return this.perDiemRepository.findByPortalUserId(userId);
    }

    public List<Pto> getPtoSubmissionsByUser(Long userId) {
        return this.ptoRepository.findByPortalUserId(userId);
    }

    public List<TargetOrder> getTargetOrderSubmissionsByUser(Long userId) {
        return this.targetOrderRepository.findByPortalUserId(userId);
    }

    public List<Termination> getTerminationSubmissionsByUser(Long userId) {
        return this.terminationRepository.findAllByPortalUserId(userId);
    }

    public List<TimeAdjustment> getTimeAdjustmentSubmissionsByUser(Long userId) {
        return this.timeAdjustmentRepository.findAllByPortalUserId(userId);
    }

    public List<Uniform> getUniformSubmissionsByUser(Long userId) {
        return this.uniformRepository.findByPortalUserId(userId);
    }

    public List<WorkTicket> getWorkTicketSubmissionsByUser(Long userId) {
        return this.workTicketRepository.findAllByPortalUserId(userId);
    }
}

