/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.WorkTicketRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.WorkTicketService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class WorkTicketServiceImpl
implements WorkTicketService {
    final Logger log = LoggerFactory.getLogger(WorkTicketServiceImpl.class);
    private final WorkTicketRepository workTicketRepository;
    private final MicrosoftGraphEmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final PdfStorageHelper pdfStorageHelper;
    private final String htmlFormLocation;

    public WorkTicketServiceImpl(WorkTicketRepository workTicketRepository, MicrosoftGraphEmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        this.workTicketRepository = workTicketRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
    }

    public FormSubmissionResponse processWorkTicket(WorkTicket wt, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File wtHtml = new File(this.htmlFormLocation + "workticket.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = wt.getEmployee().getEmployeeFirst() + " " + wt.getEmployee().getEmployeeLast();
        String pdfFileName = "wt-" + wt.getEmployee().getEmployeeNumber() + "-" + LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() + ".pdf";
        String base = this.customProperties.getPdfFiles();
        if (base == null || base.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, new String[]{"wt", wt.getEmployee().getEmployeeNumber().toString()});
        Document doc = Jsoup.parse((File)wtHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("currentLocation").html(wt.getCurrentLocation().getStoreNum() + " " + wt.getCurrentLocation().getName());
        doc.getElementsByClass("city").html(wt.getCurrentLocation().getCity());
        doc.getElementsByClass("state").html(wt.getCurrentLocation().getState());
        doc.getElementsByClass("projectStoreName").html(wt.getProjectLocation().getStoreNum() + " " + wt.getProjectLocation().getName());
        doc.getElementsByClass("projectStoreCity").html(wt.getProjectLocation().getCity());
        doc.getElementsByClass("projectStoreState").html(wt.getProjectLocation().getState());
        doc.getElementsByClass("typeOfWork").html(wt.getTypeOfWork().getTypeOfWork());
        doc.getElementsByClass("employeeNum").html(wt.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeName);
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("notes").html(wt.getNotes());
        doc.getElementsByClass("equipmentNeeded").html(wt.getEquipmentNeeded());
        doc.getElementsByClass("isBillable").html(wt.getIsBillable());
        doc.getElementsByClass("orderSubmitted").html(wt.getSupplyOrderSubmitted() != false ? "Yes" : "No");
        doc.getElementsByClass("orderNumber").html(wt.getOrderNumber());
        doc.getElementsByClass("supplyOrderDate").html(dateFormatter.format(wt.getSupplyOrderDate()));
        doc.getElementsByClass("projectStartDate").html(dateFormatter.format(wt.getProjectStartDate()));
        doc.getElementsByClass("projectEndDate").html(dateFormatter.format(wt.getProjectEndDate()));
        doc.getElementsByClass("dm").html(wt.getPortalUser().getUserFirst() + " " + wt.getPortalUser().getUserLast());
        try {
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                String financeEmail = (String)this.customProperties.getDepartmentEmails().get("Finance");
                if (financeEmail == null || financeEmail.isBlank()) {
                    throw new IllegalStateException("Missing cbm.departmentEmails.Finance configuration for Work Ticket");
                }
                List<String> recipients = List.of(financeEmail, wt.getPortalUser().getEmail());
                String subject = "Work Ticket - " + fullEmployeeName;
                String htmlBody = "<html><body><h3>Work Ticket Submission</h3><p>Please find attached the work ticket for employee: <strong>" + fullEmployeeName + "</strong></p><p>Employee Number: " + wt.getEmployee().getEmployeeNumber() + "</p><p>Current Location: " + wt.getCurrentLocation().getStoreNum() + " " + wt.getCurrentLocation().getName() + "</p><p>Project Location: " + wt.getProjectLocation().getStoreNum() + " " + wt.getProjectLocation().getName() + "</p></body></html>";
                this.emailService.sendEmail(recipients, subject, htmlBody, f);
                response.setStatus(HttpStatus.OK.value());
                wt.setSubmittedDate(LocalDateTime.now());
                WorkTicket savedWT = (WorkTicket)this.workTicketRepository.save((Object)wt);
                if (savedWT.getId() != null) {
                    formResponse.setFormName("Work Ticket");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/finance/workTicketSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setApiError(error);
            formResponse.setFormName("Work Ticket");
            formResponse.setSuccess(false);
        }
        return formResponse;
    }
}

