/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.UniformRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.UniformService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class UniformServiceImpl
extends AbstractFormProcessingService<Uniform>
implements UniformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UniformServiceImpl.class);
    private final CustomProperties customProperties;

    public UniformServiceImpl(UniformRepository uniformRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)uniformRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processUniform(Uniform uniform, HttpServletResponse response) {
        return this.processForm((Object)uniform);
    }

    protected void validateFormData(Uniform uniform) {
        if (uniform == null) {
            throw new FormProcessingException("Uniform data cannot be null");
        }
        if (uniform.getEmployee() == null || uniform.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (uniform.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (uniform.getQuantity() == null || uniform.getQuantity() <= 0) {
            throw new FormProcessingException("Quantity must be greater than zero");
        }
    }

    protected FormContext buildFormContext(Uniform uniform) {
        String fullEmployeeName = uniform.getEmployee().getEmployeeFirst() + " " + uniform.getEmployee().getEmployeeLast();
        String empNum = uniform.getEmployee().getEmployeeNumber().toString();
        String hrEmail = (String)this.customProperties.getDepartmentEmails().get("HR");
        if (hrEmail == null || hrEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.HR configuration for Uniform");
        }
        return FormContext.builder().employeeName(fullEmployeeName).employeeNumber(empNum).pdfFileName("uniform-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"uniform", empNum})).recipients(List.of(hrEmail, uniform.getPortalUser().getEmail())).emailSubject("Uniform Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(uniform.getPortalUser().getUserFirst() + " " + uniform.getPortalUser().getUserLast()).formType("UNIFORM").build();
    }

    protected Document generateHtmlDocument(FormContext context, Uniform uniform) throws IOException {
        File uniformHtml = new File(this.htmlFormLocation + "uniform.html");
        Document doc = Jsoup.parse((File)uniformHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("employeeNum").html(context.getEmployeeNumber());
        doc.getElementsByClass("employeeName").html(context.getEmployeeName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("size").html(uniform.getSize() != null ? uniform.getSize().toString() : "");
        doc.getElementsByClass("quantity").html(uniform.getQuantity().toString());
        doc.getElementsByClass("total").html(uniform.getTotal().toString());
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Uniform Form";
    }

    protected Long getEntityId(Uniform entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(Uniform uniform) {
        uniform.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return "<html><body><h3>Uniform Form Submission</h3><p>Please find attached the uniform form for employee: <strong>" + employeeName + "</strong></p><p>Employee Number: " + employeeNumber + "</p></body></html>";
    }
}

