/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.TimeAdjustBreak;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.DatabaseOperationException;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.TimeAdjustmentRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TimeAdjustmentService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class TimeAdjustmentServiceImpl
implements TimeAdjustmentService {
    private final Logger log = LoggerFactory.getLogger(TimeAdjustmentServiceImpl.class);
    private final TimeAdjustmentRepository timeAdjustmentRepository;
    private final MicrosoftGraphEmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final PdfStorageHelper pdfStorageHelper;
    private final String htmlFormLocation;

    public TimeAdjustmentServiceImpl(TimeAdjustmentRepository timeAdjustmentRepository, MicrosoftGraphEmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        this.timeAdjustmentRepository = timeAdjustmentRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
    }

    public FormSubmissionResponse processTimeAdjustment(TimeAdjustment timeAdjustment) {
        try {
            StringBuilder breakInfo = new StringBuilder();
            File adjustInfo = new File(this.htmlFormLocation + "timeadjustment.html");
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu hh:mm a");
            String fullEmployeeName = timeAdjustment.getEmployee().getEmployeeFirst() + " " + timeAdjustment.getEmployee().getEmployeeLast();
            String pdfFileName = "timeAdjustment-" + timeAdjustment.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
            String base = this.customProperties.getPdfFiles();
            if (base == null || base.isBlank()) {
                throw new FormProcessingException("cbm.pdfFiles configuration is missing");
            }
            String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, new String[]{"timeAdjust", timeAdjustment.getEmployee().getEmployeeNumber().toString()});
            this.generateBreakInfo(breakInfo, timeAdjustment, dateFormatter, timeFormatter);
            Document doc = Jsoup.parse((File)adjustInfo, (String)"UTF-8", (String)"");
            this.log.info(doc.html());
            doc.getElementsByClass("breakInfo").html(breakInfo.toString());
            doc.getElementsByClass("employeeNum").html(timeAdjustment.getEmployee().getEmployeeNumber().toString());
            doc.getElementsByClass("employeeName").html(fullEmployeeName);
            doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
            doc.getElementsByClass("reasonMissed").html(timeAdjustment.getReasonMissed());
            doc.getElementsByClass("employeeSig").html("<img src=" + timeAdjustment.getEmployeeSig() + " alt=\" This is employee signature\" />");
            doc.getElementsByClass("dmSig").html("<img src=" + timeAdjustment.getManagerSig() + " alt=\" This is manager signature\" />");
            doc.getElementsByClass("dm").html(timeAdjustment.getPortalUser().getUserFirst() + " " + timeAdjustment.getPortalUser().getUserLast());
            File pdfFile = new File(pdfSaveLocation + pdfFileName);
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (!pdfFile.exists() || pdfFile.isDirectory()) {
                throw new FormProcessingException("Failed to generate PDF file: " + pdfFileName);
            }
            this.log.info("PDF file created successfully: {}", (Object)pdfFileName);
            String payrollEmail = (String)this.customProperties.getDepartmentEmails().get("Payroll");
            if (payrollEmail == null || payrollEmail.isBlank()) {
                throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for Back Pay");
            }
            String subject = "Time Adjustment Form - " + fullEmployeeName;
            String htmlBody = "<html><body><h3>Time Adjustment Form Submission</h3><p>Please find attached the time adjustment form for employee: <strong>" + fullEmployeeName + "</strong></p><p>Employee Number: " + timeAdjustment.getEmployee().getEmployeeNumber() + "</p></body></html>";
            this.emailService.sendEmail(payrollEmail, subject, htmlBody, pdfFile);
            TimeAdjustment savedTimeAdjustment = (TimeAdjustment)this.timeAdjustmentRepository.save((Object)timeAdjustment);
            if (savedTimeAdjustment.getId() == null) {
                throw new DatabaseOperationException("Failed to save back pay record");
            }
            FormSubmissionResponse formResponse = new FormSubmissionResponse();
            formResponse.setFormName("BackPay Form");
            formResponse.setSuccess(true);
            return formResponse;
        }
        catch (IOException ioExc) {
            this.log.error("IO error processing back pay form", (Throwable)ioExc);
            throw new FormProcessingException("Error generating or sending back pay form", (Throwable)ioExc);
        }
        catch (DataAccessException dbExc) {
            this.log.error("Database error processing back pay form", (Throwable)dbExc);
            throw new DatabaseOperationException("Failed to save back pay data", (Throwable)dbExc);
        }
        catch (NullPointerException npe) {
            this.log.error("Null pointer error processing back pay form", (Throwable)npe);
            throw new FormProcessingException("Missing required data in back pay form", (Throwable)npe);
        }
    }

    private void generateBreakInfo(StringBuilder breakInfo, TimeAdjustment timeAdjustment, DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter) {
        for (TimeAdjustBreak breaks : timeAdjustment.getBreaks()) {
            Long totalHours = Duration.between(breaks.getPunchIn(), breaks.getPunchOut()).toHours();
            Double adjustedHours = (double)totalHours.longValue() - breaks.getBreakAmount();
            breakInfo.append("<div class=adjust-date >").append(dateFormatter.format(breaks.getDate())).append("</div>");
            breakInfo.append("<div class=adjust-start-time>").append(timeFormatter.format(breaks.getPunchIn())).append("</div>");
            breakInfo.append("<div class=adjust-end-time>").append(timeFormatter.format(breaks.getPunchOut())).append("</div>");
            breakInfo.append("<div class=adjust-total-hrs>").append(totalHours).append(" hrs</div>");
            breakInfo.append("<div class=adjust-break-time>").append(breaks.getBreakAmount()).append(" hrs</div>");
            breakInfo.append("<div class=adjust-adjusted-hrs>").append(adjustedHours).append(" hrs</div>");
        }
    }
}

