/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.MileageRepository;
import com.cbmportal.portal.services.MileageService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class MileageServiceImpl
extends AbstractFormProcessingService<Mileage>
implements MileageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MileageServiceImpl.class);
    private final CustomProperties customProperties;

    public MileageServiceImpl(MileageRepository mileageRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)mileageRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processMileage(Mileage mileage) {
        return this.processForm((Object)mileage);
    }

    protected void validateFormData(Mileage mileage) {
        if (mileage == null) {
            throw new FormProcessingException("Mileage data cannot be null");
        }
        if (mileage.getEmployee() == null || mileage.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (mileage.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (mileage.getMileageDates() == null || mileage.getMileageDates().isEmpty()) {
            throw new FormProcessingException("At least one mileage entry is required");
        }
    }

    protected FormContext buildFormContext(Mileage mileage) {
        String fullEmployeeName = mileage.getEmployee().getEmployeeFirst() + " " + mileage.getEmployee().getEmployeeLast();
        String empNum = mileage.getEmployee().getEmployeeNumber().toString();
        String payrollEmail = (String)this.customProperties.getDepartmentEmails().get("Payroll");
        if (payrollEmail == null || payrollEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for Back Pay");
        }
        return FormContext.builder().employeeName(fullEmployeeName).employeeNumber(empNum).pdfFileName("Mileage-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"mileage", empNum})).recipients(List.of(payrollEmail, mileage.getPortalUser().getEmail())).emailSubject("Mileage Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(mileage.getPortalUser().getUserFirst() + " " + mileage.getPortalUser().getUserLast()).comments(mileage.getComments()).formType("MILEAGE").build();
    }

    protected Document generateHtmlDocument(FormContext context, Mileage mileage) throws IOException {
        File mileageHtml = new File(this.htmlFormLocation + "mileage.html");
        Document doc = Jsoup.parse((File)mileageHtml, (String)"UTF-8", (String)"");
        StringBuilder mileageInfo = new StringBuilder();
        for (MileageDate mileageItem : mileage.getMileageDates()) {
            mileageInfo.append("<div class=\"mileage-date\">").append(this.dateFormatter.format(mileageItem.getDate())).append("</div>");
            mileageInfo.append("<div class=\"mileage-starting-location\">").append(mileageItem.getLocation1().getStoreNum()).append(" ").append(mileageItem.getLocation1().getName()).append("</div>");
            mileageInfo.append("<div class=\"mileage-ending-location\">").append(mileageItem.getLocation2().getStoreNum()).append(" ").append(mileageItem.getLocation2().getName()).append("</div>");
        }
        doc.getElementsByClass("mileageInfo").html(mileageInfo.toString());
        doc.getElementsByClass("comments").html(context.getComments() != null ? context.getComments() : "");
        doc.getElementsByClass("employeeNum").html(context.getEmployeeNumber());
        doc.getElementsByClass("employeeName").html(context.getEmployeeName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Mileage Form";
    }

    protected Long getEntityId(Mileage entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(Mileage mileage) {
        mileage.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return "<html><body><h3>Mileage Form Submission</h3><p>Please find attached the mileage form for employee: <strong>" + employeeName + "</strong></p><p>Employee Number: " + employeeNumber + "</p></body></html>";
    }
}

