/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.BonusDate;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.BonusRepository;
import com.cbmportal.portal.services.BonusService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class BonusServiceImpl
extends AbstractFormProcessingService<Bonus>
implements BonusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BonusServiceImpl.class);
    private final CustomProperties customProperties;

    public BonusServiceImpl(BonusRepository bonusRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)bonusRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processBonus(Bonus bonus) {
        return this.processForm((Object)bonus);
    }

    protected void validateFormData(Bonus bonus) {
        if (bonus == null) {
            throw new FormProcessingException("Bonus data cannot be null");
        }
        if (bonus.getEmployee() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (bonus.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee number is required");
        }
        if (bonus.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (bonus.getBonuses() == null || bonus.getBonuses().isEmpty()) {
            throw new FormProcessingException("At least one bonus entry is required");
        }
    }

    protected FormContext buildFormContext(Bonus bonus) {
        String fullEmployeeName = bonus.getEmployee().getEmployeeFirst() + " " + bonus.getEmployee().getEmployeeLast();
        String empNum = bonus.getEmployee().getEmployeeNumber().toString();
        String currentDate = this.dateFormatter.format(LocalDate.now());
        String payrollEmail = (String)this.customProperties.getDepartmentEmails().get("Payroll");
        if (payrollEmail == null || payrollEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for Back Pay");
        }
        return FormContext.builder().employeeName(fullEmployeeName).employeeNumber(empNum).pdfFileName("Bonus-" + empNum + "-" + currentDate + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"bonus", empNum})).recipients(List.of(payrollEmail, bonus.getPortalUser().getEmail())).emailSubject("Bonus Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(bonus.getPortalUser().getUserFirst() + " " + bonus.getPortalUser().getUserLast()).comments(bonus.getComments()).formType("BONUS").build();
    }

    protected Document generateHtmlDocument(FormContext context, Bonus bonus) throws IOException {
        File bonusHtml = new File(this.htmlFormLocation + "bonus.html");
        Document doc = Jsoup.parse((File)bonusHtml, (String)"UTF-8", (String)"");
        StringBuilder bonusInfo = new StringBuilder();
        for (BonusDate bonusItem : bonus.getBonuses()) {
            bonusInfo.append("<div class=\"date-info\">").append(this.dateFormatter.format(bonusItem.getDate())).append("</div>");
            bonusInfo.append("<div class=\"location-info\">").append(bonusItem.getStore().getStoreNum()).append(" ").append(bonusItem.getStore().getName()).append("</div>");
            bonusInfo.append("<div class=\"amount-info\">").append(bonusItem.getBonus()).append("</div>");
        }
        doc.getElementsByClass("bonusInfo").html(bonusInfo.toString());
        doc.getElementsByClass("comments").html(context.getComments() != null ? context.getComments() : "");
        doc.getElementsByClass("employeeNum").html(context.getEmployeeNumber());
        doc.getElementsByClass("employeeName").html(context.getEmployeeName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dmSig").html("<img src=" + bonus.getSig() + " alt=\"Signature\" />");
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Bonus Form";
    }

    protected Long getEntityId(Bonus entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(Bonus bonus) {
        bonus.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return "<html><body><h3>Bonus Form Submission</h3><p>Please find attached the bonus form for employee: <strong>" + employeeName + "</strong></p><p>Employee Number: " + employeeNumber + "</p></body></html>";
    }
}

