/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.BackPayDate;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.BackpayRepository;
import com.cbmportal.portal.services.BackPayService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class BackPayServiceImpl
extends AbstractFormProcessingService<BackPay>
implements BackPayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackPayServiceImpl.class);
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("hh:mm a");
    private final CustomProperties customProperties;

    public BackPayServiceImpl(BackpayRepository backpayRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)backpayRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processBackPay(BackPay backPay) {
        return this.processForm((Object)backPay);
    }

    protected void validateFormData(BackPay backPay) {
        if (backPay == null) {
            throw new FormProcessingException("Back pay data cannot be null");
        }
        if (backPay.getEmployee() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (backPay.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee number is required");
        }
        if (backPay.getStore() == null) {
            throw new FormProcessingException("Store information is required");
        }
        if (backPay.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (backPay.getBackPayDates() == null || backPay.getBackPayDates().isEmpty()) {
            throw new FormProcessingException("At least one back pay date is required");
        }
    }

    protected FormContext buildFormContext(BackPay backPay) {
        String fullEmployeeName = backPay.getEmployee().getEmployeeFirst() + " " + backPay.getEmployee().getEmployeeLast();
        String empNum = backPay.getEmployee().getEmployeeNumber().toString();
        String currentDate = this.dateFormatter.format(LocalDate.now());
        String payrollEmail = (String)this.customProperties.getDepartmentEmails().get("Payroll");
        if (payrollEmail == null || payrollEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for Back Pay");
        }
        return FormContext.builder().employeeName(fullEmployeeName).employeeNumber(empNum).pdfFileName("Backpay-" + empNum + "-" + currentDate + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"backpay", empNum})).recipients(List.of(payrollEmail, backPay.getPortalUser().getEmail())).emailSubject("Back Pay Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum, backPay.getStore())).storeName(backPay.getStore().getName()).storeNumber(backPay.getStore().getStoreNum()).portalUserName(backPay.getPortalUser().getUserFirst() + " " + backPay.getPortalUser().getUserLast()).formType("BACKPAY").build();
    }

    protected Document generateHtmlDocument(FormContext context, BackPay backPay) throws IOException {
        File bpHtml = new File(this.htmlFormLocation + "backpay.html");
        Document doc = Jsoup.parse((File)bpHtml, (String)"UTF-8", (String)"");
        StringBuilder backPayDateInfo = new StringBuilder();
        for (BackPayDate backPayDate : backPay.getBackPayDates()) {
            double shiftHours = this.getShiftHours(backPayDate);
            double breakHours = this.getBreakHours(backPayDate);
            BigDecimal netHours = BigDecimal.valueOf(shiftHours - breakHours);
            this.backPayInfoInject(netHours, backPayDate, backPayDateInfo);
        }
        doc.getElementsByClass("backPayInfo").html(backPayDateInfo.toString());
        doc.getElementsByClass("todayDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("employeeNum").html(context.getEmployeeNumber());
        doc.getElementsByClass("employeeName").html(context.getEmployeeName());
        doc.getElementsByClass("storeName").html(context.getStoreNumber() + " " + context.getStoreName());
        doc.getElementsByClass("dmName").html(context.getPortalUserName());
        doc.getElementsByClass("dmSig").html("<img src=" + backPay.getSig() + " alt=\"Signature\" />");
        doc.getElementsByClass("reasonMissed").html(backPay.getPayMissed());
        return doc;
    }

    protected String getFormName() {
        return "Back Pay Form";
    }

    protected Long getEntityId(BackPay entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(BackPay backPay) {
        backPay.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber, Store store) {
        return "<html><body><h3>Back Pay Form Submission</h3><p>Please find attached the back pay form for employee: <strong>" + employeeName + "</strong></p><p>Employee Number: " + employeeNumber + "</p><p>Store: " + store.getStoreNum() + " " + store.getName() + "</p></body></html>";
    }

    private double getShiftHours(BackPayDate backPayDate) {
        return backPayDate.getPunchIn().until(backPayDate.getPunchOut(), ChronoUnit.HOURS);
    }

    private double getBreakHours(BackPayDate backPayDate) {
        if (backPayDate.getLeft_lunch() != null && backPayDate.getReturn_lunch() != null) {
            return (double)LocalDateTime.parse(backPayDate.getLeft_lunch()).until(LocalDateTime.parse(backPayDate.getReturn_lunch()), ChronoUnit.MINUTES) / 60.0;
        }
        return 0.0;
    }

    private void backPayInfoInject(BigDecimal netHours, BackPayDate backPayDate, StringBuilder backPayDateInfo) {
        backPayDateInfo.append("<div class=backPayInfoContainer>");
        backPayDateInfo.append("<div style=\"width: 13%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(this.dateFormatter.format(backPayDate.getDate())).append("</div>");
        backPayDateInfo.append("<div style=\"width: 15%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(this.timeFormatter.format(backPayDate.getPunchIn())).append("</div>");
        if (backPayDate.getLeft_lunch() == null || backPayDate.getReturn_lunch() == null) {
            backPayDateInfo.append("<div style=\"width: 22%; border-bottom: 1px solid black; padding: 1px; text-align: left;\"> No Time </div>");
            backPayDateInfo.append("<div style=\"width: 21%; border-bottom: 1px solid black; padding: 1px; text-align: left;\"> No Time </div>");
        } else {
            backPayDateInfo.append("<div style=\"width: 21%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(this.timeFormatter.format(LocalDateTime.parse(backPayDate.getLeft_lunch()))).append("</div>");
            backPayDateInfo.append("<div style=\"width: 22%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(this.timeFormatter.format(LocalDateTime.parse(backPayDate.getReturn_lunch()))).append("</div>");
        }
        backPayDateInfo.append("<div style=\"width: 13%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(this.timeFormatter.format(backPayDate.getPunchOut())).append("</div>");
        backPayDateInfo.append("<div style=\"width: 12%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(netHours.setScale(2, RoundingMode.UP)).append(" hrs</div>");
        backPayDateInfo.append("</div>");
    }
}

