/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.LoginRequestVO;
import com.cbmportal.portal.domains.VO.LoginResponseVO;
import com.cbmportal.portal.exceptions.ValidationException;
import com.cbmportal.portal.services.AuthenticationService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/auth"})
public class Auth {
    private static final Logger log = LoggerFactory.getLogger(Auth.class);
    private final AuthenticationService authenticationService;

    public Auth(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<PortalUser> registerUser(@RequestBody PortalUser portalUser) {
        log.info("User registration request for username: {}", (Object)portalUser.getUsername());
        PortalUser registeredUser = this.authenticationService.registerUser(portalUser);
        log.info("User registered successfully: {}", (Object)registeredUser.getUsername());
        return ResponseEntity.ok((Object)registeredUser);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<LoginResponseVO> loginUser(@RequestBody LoginRequestVO loginRequest, HttpServletRequest request) {
        if (loginRequest.getUsername() == null || loginRequest.getUsername().isEmpty() || loginRequest.getPassword() == null || loginRequest.getPassword().isEmpty()) {
            log.warn("Login attempt with missing credentials");
            throw new ValidationException("Username and password are required");
        }
        log.info("Login attempt for user: {}", (Object)loginRequest.getUsername());
        String deviceInfo = request.getHeader("User-Agent");
        String ipAddress = request.getRemoteAddr();
        LoginResponseVO loginResponse = this.authenticationService.loginUser(loginRequest.getUsername(), loginRequest.getPassword(), loginRequest.isRememberMe(), deviceInfo, ipAddress);
        log.info("Login successful for user: {}", (Object)loginRequest.getUsername());
        return ResponseEntity.ok((Object)loginResponse);
    }

    @PostMapping(value={"/refresh"})
    public ResponseEntity<LoginResponseVO> refreshToken(@RequestBody Map<String, String> request) {
        String refreshToken = request.get("refreshToken");
        if (refreshToken == null || refreshToken.isEmpty()) {
            log.warn("Refresh token request with empty token");
            throw new ValidationException("Refresh token is required");
        }
        log.debug("Refresh token request received");
        LoginResponseVO response = this.authenticationService.refreshAccessToken(refreshToken);
        log.info("Access token refreshed successfully for user: {}", (Object)response.getUser().getUserName());
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<Void> logout(@RequestBody Map<String, String> request) {
        String refreshToken = request.get("refreshToken");
        if (refreshToken != null && !refreshToken.isEmpty()) {
            log.info("Logout request with refresh token");
            this.authenticationService.logout(refreshToken);
        }
        log.info("Logout successful");
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/validateToken"})
    public ResponseEntity<LoginResponseVO> validateToken(@RequestParam String token) {
        if (token == null || token.isEmpty()) {
            log.warn("Token validation requested with empty token");
            throw new ValidationException("Token is required");
        }
        log.debug("Token validation requested");
        LoginResponseVO validationResponse = this.authenticationService.validateJwt(token);
        log.debug("Token validated successfully for user: {}", (Object)validationResponse.getUser().getUserName());
        return ResponseEntity.ok((Object)validationResponse);
    }
}

