/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.TargetOrder;
import com.cbmportal.portal.domains.TargetOrderItem;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.TargetOrderRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TargetOrderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class TargetOrderServiceImpl
extends AbstractFormProcessingService<TargetOrder>
implements TargetOrderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TargetOrderServiceImpl.class);
    private final CustomProperties customProperties;

    public TargetOrderServiceImpl(TargetOrderRepository targetOrderRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)targetOrderRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processTargetOrder(TargetOrder targetOrder, HttpServletResponse response) {
        return this.processForm((Object)targetOrder);
    }

    protected void validateFormData(TargetOrder targetOrder) {
        if (targetOrder == null) {
            throw new FormProcessingException("Target order data cannot be null");
        }
        if (targetOrder.getStore() == null) {
            throw new FormProcessingException("Store information is required");
        }
        if (targetOrder.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (targetOrder.getTargetOrderItems() == null || targetOrder.getTargetOrderItems().isEmpty()) {
            throw new FormProcessingException("At least one target order item is required");
        }
    }

    protected FormContext buildFormContext(TargetOrder targetOrder) {
        String submitterName = targetOrder.getPortalUser().getUserFirst() + " " + targetOrder.getPortalUser().getUserLast();
        String storeInfo = targetOrder.getStore().getStoreNum() + " " + targetOrder.getStore().getName();
        String suppyEmail = (String)this.customProperties.getDepartmentEmails().get("Supply");
        if (suppyEmail == null || suppyEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for TargetOrder");
        }
        return FormContext.builder().storeName(targetOrder.getStore().getName()).storeNumber(targetOrder.getStore().getStoreNum()).pdfFileName("TargetOrder-" + targetOrder.getStore().getStoreNum() + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"targetorder", targetOrder.getStore().getStoreNum()})).recipients(List.of(suppyEmail, targetOrder.getPortalUser().getEmail())).emailSubject("Target Order Form - " + storeInfo).emailBody(this.buildEmailBody(storeInfo, submitterName)).portalUserName(submitterName).formType("TARGET_ORDER").build();
    }

    protected Document generateHtmlDocument(FormContext context, TargetOrder targetOrder) throws IOException {
        File targetOrderHtml = new File(this.htmlFormLocation + "targetorder.html");
        Document doc = Jsoup.parse((File)targetOrderHtml, (String)"UTF-8", (String)"");
        StringBuilder orderItems = new StringBuilder();
        for (TargetOrderItem item : targetOrder.getTargetOrderItems()) {
            orderItems.append("<div class=\"item-description\">").append(item.getName()).append("</div>");
            orderItems.append("<div class=\"item-quantity\">").append(item.getQuantity()).append("</div>");
        }
        doc.getElementsByClass("storeName").html(context.getStoreNumber() + " " + context.getStoreName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("orderItems").html(orderItems.toString());
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Target Order Form";
    }

    protected Long getEntityId(TargetOrder entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(TargetOrder targetOrder) {
        targetOrder.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String storeInfo, String submitterName) {
        return "<html><body><h3>Target Order Form Submission</h3><p>Please find attached the target order form for store: <strong>" + storeInfo + "</strong></p><p>Submitted by: " + submitterName + "</p></body></html>";
    }
}

