/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.NonMnMileageRepository;
import com.cbmportal.portal.services.NonMnMileageService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class NonMnMileageServiceImpl
extends AbstractFormProcessingService<NonMnMileage>
implements NonMnMileageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonMnMileageServiceImpl.class);
    private final CustomProperties customProperties;

    public NonMnMileageServiceImpl(NonMnMileageRepository nonMnMileageRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)nonMnMileageRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processMileage(NonMnMileage mileage, HttpServletResponse response) {
        return this.processForm((Object)mileage);
    }

    protected void validateFormData(NonMnMileage mileage) {
        if (mileage == null) {
            throw new FormProcessingException("Non-MN mileage data cannot be null");
        }
        if (mileage.getEmployee() == null || mileage.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (mileage.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (mileage.getMileageDates() == null || mileage.getMileageDates().isEmpty()) {
            throw new FormProcessingException("At least one mileage date is required");
        }
    }

    protected FormContext buildFormContext(NonMnMileage mileage) {
        String fullEmployeeName = mileage.getEmployee().getEmployeeFirst() + " " + mileage.getEmployee().getEmployeeLast();
        String empNum = mileage.getEmployee().getEmployeeNumber().toString();
        String payrollEmail = (String)this.customProperties.getDepartmentEmails().get("Finance");
        if (payrollEmail == null || payrollEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for Non-MN Mileage");
        }
        return FormContext.builder().employeeName(fullEmployeeName).employeeNumber(empNum).pdfFileName("NonMnMileage-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"nonmnmileage", empNum})).recipients(List.of(payrollEmail, mileage.getPortalUser().getEmail())).emailSubject("Non-MN Mileage Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum)).portalUserName(mileage.getPortalUser().getUserFirst() + " " + mileage.getPortalUser().getUserLast()).comments(mileage.getComments()).formType("NON_MN_MILEAGE").build();
    }

    protected Document generateHtmlDocument(FormContext context, NonMnMileage mileage) throws IOException {
        File mileageHtml = new File(this.htmlFormLocation + "nonmnmileage.html");
        Document doc = Jsoup.parse((File)mileageHtml, (String)"UTF-8", (String)"");
        StringBuilder mileageInfo = new StringBuilder();
        for (MileageDate mileageDate : mileage.getMileageDates()) {
            mileageInfo.append("<div class=\"mileage-date\">").append(this.dateFormatter.format(mileageDate.getDate())).append("</div>");
            mileageInfo.append("<div class=\"mileage-starting-location\">").append(mileageDate.getLocation1().getStoreNum()).append(" ").append(mileageDate.getLocation1().getName()).append("</div>");
            mileageInfo.append("<div class=\"mileage-ending-location\">").append(mileageDate.getLocation2().getStoreNum()).append(" ").append(mileageDate.getLocation2().getName()).append("</div>");
            mileageInfo.append("<div class=\"rt-ow-info\">").append(mileageDate.getRt_ow()).append("</div>");
        }
        doc.getElementsByClass("employeeNum").html(context.getEmployeeNumber());
        doc.getElementsByClass("employeeName").html(context.getEmployeeName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("mileageInfo").html(mileageInfo.toString());
        doc.getElementsByClass("comments").html(context.getComments() != null ? context.getComments() : "");
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "Non-MN Mileage Form";
    }

    protected Long getEntityId(NonMnMileage entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(NonMnMileage mileage) {
        mileage.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber) {
        return "<html><body><h3>Non-MN Mileage Form Submission</h3><p>Please find attached the non-MN mileage form for employee: <strong>" + employeeName + "</strong></p><p>Employee Number: " + employeeNumber + "</p></body></html>";
    }
}

