/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Address;
import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.NewHireRepository;
import com.cbmportal.portal.services.NewHireService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NewHireServiceImpl
implements NewHireService {
    private final Logger log = LoggerFactory.getLogger(NewHireServiceImpl.class);
    private final NewHireRepository newHireRepository;
    private final MicrosoftGraphEmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final String htmlFormLocation;
    private final PdfStorageHelper pdfStorageHelper;

    public NewHireServiceImpl(NewHireRepository newHireRepository, MicrosoftGraphEmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        this.newHireRepository = newHireRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
    }

    public FormSubmissionResponse processNewHire(NewHire newHire, MultipartFile idBadge, MultipartFile govIdFront, MultipartFile govIdRear, MultipartFile ssnCard, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File newHireHtml = new File(this.htmlFormLocation + "newhire.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String basePdfPath = this.customProperties.getPdfFiles();
        if (basePdfPath == null || basePdfPath.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String safeEmpFolder = (newHire.getEmployee().getEmployeeFirst() + "-" + newHire.getEmployee().getEmployeeLast()).replaceAll("[^a-zA-Z0-9._-]", "_");
        String pdfFileName = "newHire-" + safeEmpFolder + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(basePdfPath, new String[]{"newHire", safeEmpFolder});
        Path pdfSaveDir = Paths.get(pdfSaveLocation, new String[0]);
        Path imageDir = pdfSaveDir.resolve("image");
        Files.createDirectories(imageDir, new FileAttribute[0]);
        this.log.debug("PDF save dir: {} | image dir: {}", (Object)pdfSaveDir, (Object)imageDir);
        Path idBadgeFile = this.buildImagePath(idBadge, imageDir, "idBadge");
        Path govIdFrontFile = this.buildImagePath(govIdFront, imageDir, "govIdFront");
        Path govIdRearFile = this.buildImagePath(govIdRear, imageDir, "govIdRear");
        Path ssnCardFile = this.buildImagePath(ssnCard, imageDir, "ssnCard");
        this.ensureParent(idBadgeFile);
        this.ensureParent(govIdFrontFile);
        this.ensureParent(govIdRearFile);
        this.ensureParent(ssnCardFile);
        this.log.debug("Saving uploads: idBadge={} govFront={} govRear={} ssn={} ", new Object[]{idBadgeFile, govIdFrontFile, govIdRearFile, ssnCardFile});
        idBadge.transferTo(idBadgeFile.toFile());
        govIdFront.transferTo(govIdFrontFile.toFile());
        govIdRear.transferTo(govIdRearFile.toFile());
        ssnCard.transferTo(ssnCardFile.toFile());
        Document doc = Jsoup.parse((File)newHireHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("address").html(this.formatAddress(newHire.getEmployee().getAddress()));
        doc.getElementsByClass("phone1").html(newHire.getEmployee().getPhone1());
        doc.getElementsByClass("phone2").html(newHire.getEmployee().getPhone2());
        doc.getElementsByClass("employeeFirstName").html(newHire.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeMiddleName").html(newHire.getEmployee().getEmployeeMiddle());
        doc.getElementsByClass("employeeLastName").html(newHire.getEmployee().getEmployeeLast());
        doc.getElementsByClass("employeeSecondLastName").html(newHire.getEmployee().getEmployeeSecondLast());
        doc.getElementsByClass("email").html(newHire.getEmployee().getEmail());
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dob").html(dateFormatter.format(newHire.getEmployee().getDob()));
        doc.getElementsByClass("ssn").html(newHire.getEmployee().getSsn());
        doc.getElementsByClass("gender").html(newHire.getEmployee().getGender().getGender());
        doc.getElementsByClass("numWorkDays").html(newHire.getNumWorkDays().toString());
        doc.getElementsByClass("store").html(newHire.getStore().getStoreNum() + " " + newHire.getStore().getName());
        doc.getElementsByClass("payRate").html(newHire.getPayRate().toString());
        doc.getElementsByClass("position").html(newHire.getPosition().getPosition() + " " + newHire.getPositionNum());
        doc.getElementsByClass("numOfHours").html(newHire.getNumOfHours());
        doc.getElementsByClass("preferredLanguage").html(newHire.getPreferredLanguage());
        doc.getElementsByClass("firstDayWorked").html(dateFormatter.format(newHire.getFirstDayWorked()));
        doc.getElementsByClass("hireType").html(newHire.getHireType());
        doc.getElementsByClass("comments").html(newHire.getComments());
        doc.getElementsByClass("idBadgeLocation").html("<a href=" + String.valueOf(idBadgeFile.toFile()) + ">" + idBadge.getOriginalFilename() + "</a>");
        doc.getElementsByClass("dm").html(newHire.getPortalUser().getUserFirst() + " " + newHire.getPortalUser().getUserLast());
        doc.getElementsByClass("documentTitle").html(newHire.getDocumentTitle());
        doc.getElementsByClass("documentNumber").html(newHire.getDocumentNumber());
        doc.getElementsByClass("aNum").html(newHire.getANumber());
        doc.getElementsByClass("documentExp").html(dateFormatter.format(newHire.getDocumentExp()));
        try {
            this.pdfBuilderService.generatePdf(String.valueOf(pdfSaveDir) + File.separator, pdfFileName, doc);
            Path pdfFile = pdfSaveDir.resolve(pdfFileName);
            if (Files.exists(pdfFile, new LinkOption[0])) {
                this.log.info("{} was created successfully.", (Object)pdfFileName);
                String fullEmployeeName = newHire.getEmployee().getEmployeeFirst() + " " + newHire.getEmployee().getEmployeeLast();
                String newHiresEmail = (String)this.customProperties.getDepartmentEmails().get("NewHires");
                if (newHiresEmail == null || newHiresEmail.isBlank()) {
                    throw new IllegalStateException("Missing cbm.departmentEmails.NewHires configuration");
                }
                List<String> recipients = List.of(newHiresEmail, newHire.getPortalUser().getEmail());
                String subject = "New Hire Form - " + fullEmployeeName;
                String htmlBody = "<html><body><h3>New Hire Form Submission</h3><p>Please find attached the new hire form for employee: <strong>" + fullEmployeeName + "</strong></p><p>Position: " + newHire.getPosition().getPosition() + " " + newHire.getPositionNum() + "</p><p>Store: " + newHire.getStore().getStoreNum() + " " + newHire.getStore().getName() + "</p><p>First Day Worked: " + dateFormatter.format(newHire.getFirstDayWorked()) + "</p><p><strong>Attachments included:</strong></p><ul><li>New Hire Form (PDF)</li><li>ID Badge Photo</li><li>Government ID (Front)</li><li>Government ID (Rear)</li><li>Social Security Card</li></ul></body></html>";
                List<File> attachments = List.of(pdfFile.toFile(), idBadgeFile.toFile(), govIdFrontFile.toFile(), govIdRearFile.toFile(), ssnCardFile.toFile());
                this.emailService.sendEmail(recipients, subject, htmlBody, attachments);
                response.setStatus(HttpStatus.OK.value());
                newHire.setSubmittedDate(LocalDateTime.now());
                NewHire savedNewHire = (NewHire)this.newHireRepository.save((Object)newHire);
                if (savedNewHire.getId() != null) {
                    formResponse.setFormName("NewHire Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            this.log.error("NewHire file processing failed (basePath={}, pdfSaveDir={}, imageDir={})", new Object[]{basePdfPath, pdfSaveDir, imageDir, ioExc});
            error.setApiName("/hr/newHireSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("NewHire Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private Path buildImagePath(MultipartFile file, Path imageDir, String fallbackBaseName) {
        String original = Optional.ofNullable(file.getOriginalFilename()).orElse("");
        String ext = "";
        int dot = original.lastIndexOf(46);
        if (dot > 0 && dot < original.length() - 1) {
            ext = original.substring(dot + 1).toLowerCase();
        }
        if (ext.isBlank()) {
            ext = "png";
        }
        String baseNameOnly = dot > 0 ? original.substring(0, dot) : original;
        String sanitizedBase = this.sanitizeForFile(baseNameOnly, fallbackBaseName);
        return imageDir.resolve(sanitizedBase + "." + ext);
    }

    private void ensureParent(Path target) throws IOException {
        Path parent = target.getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    String sanitizeForFile(String original, String fallback) {
        String base = original == null || original.isBlank() ? fallback : original;
        base = base.replace(" ", "-");
        return base.replaceAll("[^a-zA-Z0-9._-]", "_");
    }

    String formatAddress(Address address) {
        if (address.getAddress2().isEmpty()) {
            return address.getAddress1() + "\n" + address.getCity() + "\n" + address.getState() + "\n" + address.getZip();
        }
        return address.getAddress1() + "\n#" + address.getAddress2() + "\n" + address.getCity() + "\n" + address.getState() + "\n" + address.getZip();
    }

    public NewHire processNewHire(NewHire newhire, MultipartFile idBadge) throws IOException {
        return null;
    }
}

