/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.HotelRepository;
import com.cbmportal.portal.services.HotelService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class HotelServiceImpl
implements HotelService {
    final Logger log = LoggerFactory.getLogger(HotelServiceImpl.class);
    private final HotelRepository hotelRepository;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final MicrosoftGraphEmailService emailService;
    private final String htmlFormLocation;
    private final PdfStorageHelper pdfStorageHelper;

    public HotelServiceImpl(HotelRepository hotelRepository, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, MicrosoftGraphEmailService emailService, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        this.hotelRepository = hotelRepository;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.emailService = emailService;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
    }

    public FormSubmissionResponse requestHotel(Hotel hotel, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File hotelHtml = new File(this.htmlFormLocation + "hotel.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String pdfFileName = "Hotel-" + hotel.getStore().getStoreNum() + "-" + hotel.getStore().getName() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String base = this.customProperties.getPdfFiles();
        if (base == null || base.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, new String[]{"hotel", hotel.getPortalUser().getUsername()});
        Document doc = Jsoup.parse((File)hotelHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("location").html(hotel.getStore().getStoreNum() + " " + hotel.getStore().getName());
        doc.getElementsByClass("numOfRooms").html(hotel.getNumOfRooms().toString());
        doc.getElementsByClass("numOfBeds").html(hotel.getNumOfBeds().toString());
        doc.getElementsByClass("psInfo").html(this.generatePSInfo(hotel, this.log));
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("checkIn").html(dateFormatter.format(hotel.getCheckIn()));
        doc.getElementsByClass("checkOut").html(dateFormatter.format(hotel.getCheckOut()));
        doc.getElementsByClass("hotelReason").html(hotel.getHotelReason().getHotelReason());
        doc.getElementsByClass("workTicketNum").html(hotel.getWorkTicket());
        doc.getElementsByClass("notes").html(hotel.getComments());
        doc.getElementsByClass("dm").html(hotel.getPortalUser().getUserFirst() + " " + hotel.getPortalUser().getUserLast());
        try {
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                String financeEmail = (String)this.customProperties.getDepartmentEmails().get("Finance");
                if (financeEmail == null || financeEmail.isBlank()) {
                    throw new IllegalStateException("Missing cbm.departmentEmails.Finance configuration for Back Pay");
                }
                List<String> recipients = List.of(financeEmail, hotel.getPortalUser().getEmail());
                String subject = "Hotel Request - " + hotel.getStore().getStoreNum() + " " + hotel.getStore().getName();
                String htmlBody = "<html><body><h3>Hotel Request Submission</h3><p>Please find attached the hotel request for location: <strong>" + hotel.getStore().getStoreNum() + " " + hotel.getStore().getName() + "</strong></p><p>Check-in: " + dateFormatter.format(hotel.getCheckIn()) + "</p><p>Check-out: " + dateFormatter.format(hotel.getCheckOut()) + "</p><p>Rooms: " + hotel.getNumOfRooms() + ", Beds: " + hotel.getNumOfBeds() + "</p></body></html>";
                this.emailService.sendEmail(recipients, subject, htmlBody, f);
                response.setStatus(HttpStatus.OK.value());
                hotel.setSubmittedDate(LocalDateTime.now());
                Hotel savedHotel = (Hotel)this.hotelRepository.save((Object)hotel);
                if (savedHotel.getId() != null) {
                    formResponse.setFormName("Hotel Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/finance/hotelSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Hotel Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    String generatePSInfo(Hotel hotel, Logger log) {
        StringBuilder ps = new StringBuilder();
        if (!hotel.getNewPS().isEmpty()) {
            ps.append("<div class=\"newps-title\">New Employee Name</div>");
            ps.append("<div class=\"newps-info\">").append(hotel.getNewPS()).append("</div>");
        } else {
            ps.append("<div class=\"ps1-title\" >Employee 1</div>");
            ps.append("<div class=\"ps1-info\">").append(hotel.getPs1().getFirstName()).append(" ").append(hotel.getPs1().getLastName()).append("</div>");
            ps.append("<div class=\"ps2-title\">Employee 2</div>");
            ps.append("<div class=\"ps2-info\">").append(hotel.getPs2().getFirstName()).append(" ").append(hotel.getPs2().getLastName()).append("</div>");
        }
        log.info(ps.toString());
        return ps.toString();
    }
}

