/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.config.SecurityProperties;
import com.cbmportal.portal.services.impl.FailedLoginAttemptService;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FailedLoginAttemptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailedLoginAttemptService.class);
    private final SecurityProperties securityProperties;
    private final Map<String, FailedAttempt> failedAttempts = new ConcurrentHashMap();

    public FailedLoginAttemptService(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public void recordFailedAttempt(String username, String ipAddress) {
        String key = username.toLowerCase();
        FailedAttempt attempt = this.failedAttempts.computeIfAbsent(key, k -> new FailedAttempt());
        attempt.incrementCount();
        attempt.setLastAttemptTime(Instant.now());
        attempt.setIpAddress(ipAddress);
        log.warn("Failed login attempt {} for user: {} from IP: {}", new Object[]{attempt.getCount(), username, ipAddress});
        if (this.isAccountLocked(username)) {
            log.warn("Account locked for user: {} after {} failed attempts", (Object)username, (Object)attempt.getCount());
        }
    }

    public void resetFailedAttempts(String username) {
        String key = username.toLowerCase();
        FailedAttempt removed = (FailedAttempt)this.failedAttempts.remove(key);
        if (removed != null && removed.getCount() > 0) {
            log.info("Reset failed login attempts for user: {} (was {} attempts)", (Object)username, (Object)removed.getCount());
        }
    }

    public boolean isAccountLocked(String username) {
        if (this.securityProperties.getMaxFailedLoginAttempts() == 0) {
            return false;
        }
        String key = username.toLowerCase();
        FailedAttempt attempt = (FailedAttempt)this.failedAttempts.get(key);
        if (attempt == null) {
            return false;
        }
        if (attempt.getCount() >= this.securityProperties.getMaxFailedLoginAttempts()) {
            Instant lockoutExpiry = attempt.getLastAttemptTime().plusSeconds((long)this.securityProperties.getLockoutDurationMinutes() * 60L);
            if (Instant.now().isBefore(lockoutExpiry)) {
                return true;
            }
            this.failedAttempts.remove(key);
            log.info("Lockout expired for user: {}", (Object)username);
            return false;
        }
        return false;
    }

    public int getFailedAttemptCount(String username) {
        String key = username.toLowerCase();
        FailedAttempt attempt = (FailedAttempt)this.failedAttempts.get(key);
        return attempt != null ? attempt.getCount() : 0;
    }

    public long getRemainingLockoutSeconds(String username) {
        if (!this.isAccountLocked(username)) {
            return 0L;
        }
        String key = username.toLowerCase();
        FailedAttempt attempt = (FailedAttempt)this.failedAttempts.get(key);
        if (attempt == null) {
            return 0L;
        }
        Instant lockoutExpiry = attempt.getLastAttemptTime().plusSeconds((long)this.securityProperties.getLockoutDurationMinutes() * 60L);
        long remaining = lockoutExpiry.getEpochSecond() - Instant.now().getEpochSecond();
        return Math.max(0L, remaining);
    }
}

