/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceInfoService.class);

    public String getBrowser(String userAgent) {
        if (userAgent == null || userAgent.isEmpty()) {
            return "Unknown";
        }
        if (userAgent.contains("Edg/")) {
            return "Edge";
        }
        if (userAgent.contains("Chrome/") && !userAgent.contains("Edg/")) {
            return "Chrome";
        }
        if (userAgent.contains("Firefox/")) {
            return "Firefox";
        }
        if (userAgent.contains("Safari/") && !userAgent.contains("Chrome/")) {
            return "Safari";
        }
        if (userAgent.contains("MSIE") || userAgent.contains("Trident/")) {
            return "Internet Explorer";
        }
        if (userAgent.contains("Opera/") || userAgent.contains("OPR/")) {
            return "Opera";
        }
        return "Unknown";
    }

    public String getOperatingSystem(String userAgent) {
        if (userAgent == null || userAgent.isEmpty()) {
            return "Unknown";
        }
        if (userAgent.contains("Windows NT 10.0")) {
            return "Windows 10/11";
        }
        if (userAgent.contains("Windows NT 6.3")) {
            return "Windows 8.1";
        }
        if (userAgent.contains("Windows NT 6.2")) {
            return "Windows 8";
        }
        if (userAgent.contains("Windows NT 6.1")) {
            return "Windows 7";
        }
        if (userAgent.contains("Windows")) {
            return "Windows";
        }
        if (userAgent.contains("Mac OS X")) {
            Pattern pattern = Pattern.compile("Mac OS X ([\\d_]+)");
            Matcher matcher = pattern.matcher(userAgent);
            if (matcher.find()) {
                return "macOS " + matcher.group(1).replace("_", ".");
            }
            return "macOS";
        }
        if (userAgent.contains("Linux")) {
            return "Linux";
        }
        if (userAgent.contains("Android")) {
            Pattern pattern = Pattern.compile("Android ([\\d.]+)");
            Matcher matcher = pattern.matcher(userAgent);
            if (matcher.find()) {
                return "Android " + matcher.group(1);
            }
            return "Android";
        }
        if (userAgent.contains("iPhone") || userAgent.contains("iPad")) {
            Pattern pattern = Pattern.compile("OS ([\\d_]+)");
            Matcher matcher = pattern.matcher(userAgent);
            if (matcher.find()) {
                return "iOS " + matcher.group(1).replace("_", ".");
            }
            return "iOS";
        }
        return "Unknown";
    }

    public String getDeviceDescription(String userAgent) {
        if (userAgent == null || userAgent.isEmpty()) {
            return "Unknown Device";
        }
        String browser = this.getBrowser(userAgent);
        String os = this.getOperatingSystem(userAgent);
        return browser + " on " + os;
    }
}

