/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.District;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;

@Entity
public class PS {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ps_id")
    @SequenceGenerator(name="ps_id", sequenceName="ps_SEQ", allocationSize=1)
    private Long id;
    @JsonProperty
    private String employeeNumber;
    @JsonProperty
    private String firstName;
    @JsonProperty
    private String lastName;
    @JsonProperty
    private String email;
    @JsonProperty
    private String phone;
    @JsonProperty
    @ManyToMany
    private List<District> districts;
    @JsonIgnore
    @OneToOne
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    private PortalUser portalUser;
    @JsonProperty
    @Transient
    private PortalUserSafeVO userSafeVO;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PS ps = (PS)o;
        return Objects.equals(this.id, ps.id) && Objects.equals(this.employeeNumber, ps.employeeNumber) && Objects.equals(this.firstName, ps.firstName) && Objects.equals(this.lastName, ps.lastName) && Objects.equals(this.email, ps.email) && Objects.equals(this.phone, ps.phone) && Objects.equals(this.districts, ps.districts) && Objects.equals(this.portalUser, ps.portalUser) && Objects.equals(this.userSafeVO, ps.userSafeVO) && Objects.equals(this.apiError, ps.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeNumber, this.firstName, this.lastName, this.email, this.phone, this.districts, this.portalUser, this.userSafeVO, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", PS.class.getSimpleName() + "[", "]").add("id=" + this.id).add("employeeNumber='" + this.employeeNumber + "'").add("firstName='" + this.firstName + "'").add("lastName='" + this.lastName + "'").add("email='" + this.email + "'").add("phone='" + this.phone + "'").add("districts=" + String.valueOf(this.districts)).add("portalUser=" + String.valueOf(this.portalUser)).add("userSafeVO=" + String.valueOf(this.userSafeVO)).add("apiError=" + String.valueOf(this.apiError)).toString();
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    @JsonProperty
    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty
    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty
    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @JsonProperty
    @Generated
    public void setDistricts(List<District> districts) {
        this.districts = districts;
    }

    @JsonIgnore
    @JsonIgnoreProperties(value={"password", "authorities", "targetOrder", "workTickets", "accountNonExpired", "accountNonLocked", "credentialsNonExpired", "enabled"})
    @Generated
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    @Generated
    public void setUserSafeVO(PortalUserSafeVO userSafeVO) {
        this.userSafeVO = userSafeVO;
    }

    @JsonProperty
    @Generated
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public List<District> getDistricts() {
        return this.districts;
    }

    @Generated
    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    @Generated
    public PortalUserSafeVO getUserSafeVO() {
        return this.userSafeVO;
    }

    @Generated
    public ApiError getApiError() {
        return this.apiError;
    }
}

