/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.FormAdminResponseVO;
import com.cbmportal.portal.domains.VO.FormCountResponseVO;
import com.cbmportal.portal.domains.VO.PaginatedFormAdminResponseVO;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.services.admin.FormAdminService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/forms"})
@PreAuthorize(value="hasAnyAuthority('Admin','Office','DM')")
public class FormAdminController {
    private final Logger log = LoggerFactory.getLogger(FormAdminController.class);
    private final FormAdminService formAdminService;
    private final PortalUserRepository portalUserRepository;

    public FormAdminController(FormAdminService formAdminService, PortalUserRepository portalUserRepository) {
        this.formAdminService = formAdminService;
        this.portalUserRepository = portalUserRepository;
    }

    private Authentication auth() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private boolean isAdminOrOffice(Authentication a) {
        if (a == null) {
            return false;
        }
        return a.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(r -> r.equals("Admin") || r.equals("Office"));
    }

    private boolean isDM(Authentication a) {
        if (a == null) {
            return false;
        }
        return a.getAuthorities().stream().anyMatch(ga -> ga.getAuthority().equals("DM"));
    }

    private Long currentUserId(Authentication a) {
        if (a == null) {
            return null;
        }
        String username = a.getName();
        return this.portalUserRepository.findByUserNameAndDisabledFalse(username).map(PortalUser::getId).orElse(null);
    }

    private <E> Page<E> paginate(List<E> items, Pageable pageable) {
        int total = items.size();
        int start = (int)Math.min(pageable.getOffset(), (long)total);
        int end = Math.min(start + pageable.getPageSize(), total);
        List<E> content = items.subList(start, end);
        return new PageImpl(content, pageable, (long)total);
    }

    @GetMapping(value={"/getFormsByPortalUser/{id}"})
    public ResponseEntity<FormAdminResponseVO> getFormsByPortalUser(@PathVariable Long id) {
        this.log.info("Fetching forms for portal user ID: {}", (Object)id);
        FormAdminResponseVO formAdminResponseVO = new FormAdminResponseVO();
        formAdminResponseVO.setBackPayList(this.formAdminService.getBackPaySubmissionsByUser(id));
        formAdminResponseVO.setBonusList(this.formAdminService.getBonusSubmissionsByUser(id));
        formAdminResponseVO.setHotelList(this.formAdminService.getHotelSubmissionsByUser(id));
        formAdminResponseVO.setMileageList(this.formAdminService.getMileageSubmissionsByUser(id));
        formAdminResponseVO.setPtoList(this.formAdminService.getPtoSubmissionsByUser(id));
        formAdminResponseVO.setNewHireList(this.formAdminService.getNewHireSubmissionsByUser(id));
        formAdminResponseVO.setPerDiemList(this.formAdminService.getPerDiemSubmissionsByUser(id));
        formAdminResponseVO.setTerminationList(this.formAdminService.getTerminationSubmissionsByUser(id));
        formAdminResponseVO.setTargetOrderList(this.formAdminService.getTargetOrderSubmissionsByUser(id));
        formAdminResponseVO.setUniformList(this.formAdminService.getUniformSubmissionsByUser(id));
        formAdminResponseVO.setWorkTicketList(this.formAdminService.getWorkTicketSubmissionsByUser(id));
        this.log.debug("Forms retrieved successfully for portal user ID: {}", (Object)id);
        return ResponseEntity.ok((Object)formAdminResponseVO);
    }

    @GetMapping(value={"/getForms"})
    public ResponseEntity<FormAdminResponseVO> getForms() {
        Authentication a = this.auth();
        if (this.isDM(a)) {
            this.log.info("DM requesting own forms only");
            Long uid = this.currentUserId(a);
            if (uid == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
            }
            FormAdminResponseVO vo = new FormAdminResponseVO();
            vo.setBackPayList(this.formAdminService.getBackPaySubmissionsByUser(uid));
            vo.setBonusList(this.formAdminService.getBonusSubmissionsByUser(uid));
            vo.setHotelList(this.formAdminService.getHotelSubmissionsByUser(uid));
            vo.setMileageList(this.formAdminService.getMileageSubmissionsByUser(uid));
            vo.setPtoList(this.formAdminService.getPtoSubmissionsByUser(uid));
            vo.setNewHireList(this.formAdminService.getNewHireSubmissionsByUser(uid));
            vo.setPerDiemList(this.formAdminService.getPerDiemSubmissionsByUser(uid));
            vo.setTerminationList(this.formAdminService.getTerminationSubmissionsByUser(uid));
            vo.setTargetOrderList(this.formAdminService.getTargetOrderSubmissionsByUser(uid));
            vo.setUniformList(this.formAdminService.getUniformSubmissionsByUser(uid));
            vo.setWorkTicketList(this.formAdminService.getWorkTicketSubmissionsByUser(uid));
            this.log.info("DM own forms retrieved successfully");
            return ResponseEntity.ok((Object)vo);
        }
        this.log.info("Fetching all forms (Admin/Office)");
        FormAdminResponseVO formAdminResponseVO = new FormAdminResponseVO();
        formAdminResponseVO.setBackPayList(this.formAdminService.getBackPaySubmissions());
        formAdminResponseVO.setBonusList(this.formAdminService.getBonusSubmissions());
        formAdminResponseVO.setHotelList(this.formAdminService.getHotelSubmissions());
        formAdminResponseVO.setMileageList(this.formAdminService.getMileageSubmissions());
        formAdminResponseVO.setPtoList(this.formAdminService.getPtoSubmissions());
        formAdminResponseVO.setNewHireList(this.formAdminService.getNewHireSubmissions());
        formAdminResponseVO.setPerDiemList(this.formAdminService.getPerDiemSubmissions());
        formAdminResponseVO.setTerminationList(this.formAdminService.getTerminationSubmissions());
        formAdminResponseVO.setTargetOrderList(this.formAdminService.getTargetOrderSubmissions());
        formAdminResponseVO.setUniformList(this.formAdminService.getUniformSubmissions());
        formAdminResponseVO.setWorkTicketList(this.formAdminService.getWorkTicketSubmissions());
        this.log.info("All forms retrieved successfully");
        return ResponseEntity.ok((Object)formAdminResponseVO);
    }

    @GetMapping(value={"/getFormsPaginated"})
    public ResponseEntity<?> getFormsPaginated(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size, @RequestParam(defaultValue="submittedDate") String sortBy, @RequestParam(defaultValue="desc") String sortDirection, @RequestParam(name="formName", required=true) String formName) {
        String fn;
        Authentication a = this.auth();
        Sort sort = sortDirection.equalsIgnoreCase("asc") ? Sort.by((String[])new String[]{sortBy}).ascending() : Sort.by((String[])new String[]{sortBy}).descending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        String string = fn = formName == null ? "" : formName.trim().toLowerCase();
        if (this.isDM(a)) {
            this.log.info("DM requesting paginated own forms only - page: {}, size: {}, form: {}", new Object[]{page, size, formName});
            Long uid = this.currentUserId(a);
            if (uid == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
            }
            PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder = PaginatedFormAdminResponseVO.builder().currentPage(page).pageSize(size);
            Page selectedPage = null;
            switch (fn) {
                case "backpay": 
                case "back_pay": 
                case "back-pay": {
                    selectedPage = this.paginate(this.formAdminService.getBackPaySubmissionsByUser(uid), (Pageable)pageable);
                    builder.backPayPage(selectedPage);
                    break;
                }
                case "bonus": {
                    selectedPage = this.paginate(this.formAdminService.getBonusSubmissionsByUser(uid), (Pageable)pageable);
                    builder.bonusPage(selectedPage);
                    break;
                }
                case "hotel": {
                    selectedPage = this.paginate(this.formAdminService.getHotelSubmissionsByUser(uid), (Pageable)pageable);
                    builder.hotelPage(selectedPage);
                    break;
                }
                case "mileage": {
                    selectedPage = this.paginate(this.formAdminService.getMileageSubmissionsByUser(uid), (Pageable)pageable);
                    builder.mileagePage(selectedPage);
                    break;
                }
                case "pto": {
                    selectedPage = this.paginate(this.formAdminService.getPtoSubmissionsByUser(uid), (Pageable)pageable);
                    builder.ptoPage(selectedPage);
                    break;
                }
                case "newhire": 
                case "new_hire": 
                case "new-hire": {
                    selectedPage = this.paginate(this.formAdminService.getNewHireSubmissionsByUser(uid), (Pageable)pageable);
                    builder.newHirePage(selectedPage);
                    break;
                }
                case "perdiem": 
                case "per_diem": 
                case "per-diem": {
                    selectedPage = this.paginate(this.formAdminService.getPerDiemSubmissionsByUser(uid), (Pageable)pageable);
                    builder.perDiemPage(selectedPage);
                    break;
                }
                case "termination": {
                    selectedPage = this.paginate(this.formAdminService.getTerminationSubmissionsByUser(uid), (Pageable)pageable);
                    builder.terminationPage(selectedPage);
                    break;
                }
                case "targetorder": 
                case "target_order": 
                case "target-order": {
                    selectedPage = this.paginate(this.formAdminService.getTargetOrderSubmissionsByUser(uid), (Pageable)pageable);
                    builder.targetOrderPage(selectedPage);
                    break;
                }
                case "uniform": {
                    selectedPage = this.paginate(this.formAdminService.getUniformSubmissionsByUser(uid), (Pageable)pageable);
                    builder.uniformPage(selectedPage);
                    break;
                }
                case "workticket": 
                case "work_ticket": 
                case "work-ticket": {
                    selectedPage = this.paginate(this.formAdminService.getWorkTicketSubmissionsByUser(uid), (Pageable)pageable);
                    builder.workTicketPage(selectedPage);
                    break;
                }
                case "nonmnmileage": 
                case "non_mn_mileage": 
                case "non-mn-mileage": {
                    selectedPage = this.paginate(this.formAdminService.getNonMnMileageSubmissionsByUser(uid), (Pageable)pageable);
                    builder.nonMnMileagePage(selectedPage);
                    break;
                }
                default: {
                    this.log.warn("Unknown formName '{}'.", (Object)formName);
                    HashMap<String, Object> body = new HashMap<String, Object>();
                    body.put("error", "Unknown formName");
                    body.put("formName", formName);
                    body.put("validOptions", Arrays.asList("backpay", "bonus", "hotel", "mileage", "pto", "newhire", "perdiem", "termination", "targetorder", "uniform", "workticket", "nonmnmileage"));
                    return ResponseEntity.unprocessableEntity().body(body);
                }
            }
            if (selectedPage != null) {
                builder.totalPages(selectedPage.getTotalPages()).totalElements(selectedPage.getTotalElements()).hasNext(selectedPage.hasNext()).hasPrevious(selectedPage.hasPrevious());
            } else {
                builder.totalPages(0).totalElements(0L).hasNext(false).hasPrevious(false);
            }
            this.log.info("DM paginated own '{}' forms retrieved successfully", (Object)formName);
            return ResponseEntity.ok((Object)builder.build());
        }
        this.log.info("Fetching paginated forms (Admin/Office) - page: {}, size: {}, form: {}", new Object[]{page, size, formName});
        PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder = PaginatedFormAdminResponseVO.builder().currentPage(page).pageSize(size);
        Page selectedPage = null;
        switch (fn) {
            case "backpay": 
            case "back_pay": 
            case "back-pay": {
                selectedPage = this.formAdminService.getBackPaySubmissionsPaginated((Pageable)pageable);
                builder.backPayPage(selectedPage);
                break;
            }
            case "bonus": {
                selectedPage = this.formAdminService.getBonusSubmissionsPaginated((Pageable)pageable);
                builder.bonusPage(selectedPage);
                break;
            }
            case "hotel": {
                selectedPage = this.formAdminService.getHotelSubmissionsPaginated((Pageable)pageable);
                builder.hotelPage(selectedPage);
                break;
            }
            case "mileage": {
                selectedPage = this.formAdminService.getMileageSubmissionsPaginated((Pageable)pageable);
                builder.mileagePage(selectedPage);
                break;
            }
            case "pto": {
                selectedPage = this.formAdminService.getPtoSubmissionsPaginated((Pageable)pageable);
                builder.ptoPage(selectedPage);
                break;
            }
            case "newhire": 
            case "new_hire": 
            case "new-hire": {
                selectedPage = this.formAdminService.getNewHireSubmissionsPaginated((Pageable)pageable);
                builder.newHirePage(selectedPage);
                break;
            }
            case "perdiem": 
            case "per_diem": 
            case "per-diem": {
                selectedPage = this.formAdminService.getPerDiemSubmissionsPaginated((Pageable)pageable);
                builder.perDiemPage(selectedPage);
                break;
            }
            case "termination": {
                selectedPage = this.formAdminService.getTerminationSubmissionsPaginated((Pageable)pageable);
                builder.terminationPage(selectedPage);
                break;
            }
            case "targetorder": 
            case "target_order": 
            case "target-order": {
                selectedPage = this.formAdminService.getTargetOrderSubmissionsPaginated((Pageable)pageable);
                builder.targetOrderPage(selectedPage);
                break;
            }
            case "uniform": {
                selectedPage = this.formAdminService.getUniformSubmissionsPaginated((Pageable)pageable);
                builder.uniformPage(selectedPage);
                break;
            }
            case "workticket": 
            case "work_ticket": 
            case "work-ticket": {
                selectedPage = this.formAdminService.getWorkTicketSubmissionsPaginated((Pageable)pageable);
                builder.workTicketPage(selectedPage);
                break;
            }
            case "nonmnmileage": 
            case "non_mn_mileage": 
            case "non-mn-mileage": {
                selectedPage = this.formAdminService.getNonMnMileageSubmissionsPaginated((Pageable)pageable);
                builder.nonMnMileagePage(selectedPage);
                break;
            }
            default: {
                this.log.warn("Unknown formName '{}'.", (Object)formName);
                HashMap<String, Object> body = new HashMap<String, Object>();
                body.put("error", "Unknown formName");
                body.put("formName", formName);
                body.put("validOptions", Arrays.asList("backpay", "bonus", "hotel", "mileage", "pto", "newhire", "perdiem", "termination", "targetorder", "uniform", "workticket", "nonmnmileage"));
                return ResponseEntity.unprocessableEntity().body(body);
            }
        }
        if (selectedPage != null) {
            builder.totalPages(selectedPage.getTotalPages()).totalElements(selectedPage.getTotalElements()).hasNext(selectedPage.hasNext()).hasPrevious(selectedPage.hasPrevious());
        } else {
            builder.totalPages(0).totalElements(0L).hasNext(false).hasPrevious(false);
        }
        this.log.info("Paginated '{}' forms retrieved successfully (Admin/Office)", (Object)formName);
        return ResponseEntity.ok((Object)builder.build());
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<FormCountResponseVO> getFormsCount() {
        Authentication a = this.auth();
        if (!this.isAdminOrOffice(a)) {
            this.log.warn("Forbidden access to forms count by non-admin/office user: {}", (Object)(a != null ? a.getName() : "anonymous"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        long backPay = this.formAdminService.countBackPaySubmissions();
        long bonus = this.formAdminService.countBonusSubmissions();
        long hotel = this.formAdminService.countHotelSubmissions();
        long mileage = this.formAdminService.countMileageSubmissions();
        long pto = this.formAdminService.countPtoSubmissions();
        long newHire = this.formAdminService.countNewHireSubmissions();
        long perDiem = this.formAdminService.countPerDiemSubmissions();
        long termination = this.formAdminService.countTerminationSubmissions();
        long targetOrder = this.formAdminService.countTargetOrderSubmissions();
        long uniform = this.formAdminService.countUniformSubmissions();
        long workTicket = this.formAdminService.countWorkTicketSubmissions();
        long nonMnMileage = this.formAdminService.countNonMnMileageSubmissions();
        long total = backPay + bonus + hotel + mileage + pto + newHire + perDiem + termination + targetOrder + uniform + workTicket + nonMnMileage;
        FormCountResponseVO response = FormCountResponseVO.builder().total(total).build();
        this.log.info("Forms total count retrieved successfully: {}", (Object)total);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/getFormsPaginatedByPortalUser/{id}"})
    public ResponseEntity<?> getFormsPaginatedByPortalUser(@PathVariable Long id, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size, @RequestParam(defaultValue="submittedDate") String sortBy, @RequestParam(defaultValue="desc") String sortDirection, @RequestParam(name="formName", required=true) String formName) {
        Page selectedPage;
        Authentication a = this.auth();
        if (!this.isAdminOrOffice(a)) {
            this.log.warn("Forbidden access to getFormsPaginatedByPortalUser by non-admin/office user: {}", (Object)(a != null ? a.getName() : "anonymous"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        this.log.info("Fetching paginated forms for portal user ID: {}, page: {}, size: {}, form: {}", new Object[]{id, page, size, formName});
        Sort sort = sortDirection.equalsIgnoreCase("asc") ? Sort.by((String[])new String[]{sortBy}).ascending() : Sort.by((String[])new String[]{sortBy}).descending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        String fn = formName == null ? "" : formName.trim().toLowerCase();
        PaginatedFormAdminResponseVO.PaginatedFormAdminResponseVOBuilder builder = PaginatedFormAdminResponseVO.builder().currentPage(page).pageSize(size);
        switch (fn) {
            case "backpay": 
            case "back_pay": 
            case "back-pay": {
                selectedPage = this.paginate(this.formAdminService.getBackPaySubmissionsByUser(id), (Pageable)pageable);
                builder.backPayPage(selectedPage);
                break;
            }
            case "bonus": {
                selectedPage = this.paginate(this.formAdminService.getBonusSubmissionsByUser(id), (Pageable)pageable);
                builder.bonusPage(selectedPage);
                break;
            }
            case "hotel": {
                selectedPage = this.paginate(this.formAdminService.getHotelSubmissionsByUser(id), (Pageable)pageable);
                builder.hotelPage(selectedPage);
                break;
            }
            case "mileage": {
                selectedPage = this.paginate(this.formAdminService.getMileageSubmissionsByUser(id), (Pageable)pageable);
                builder.mileagePage(selectedPage);
                break;
            }
            case "pto": {
                selectedPage = this.paginate(this.formAdminService.getPtoSubmissionsByUser(id), (Pageable)pageable);
                builder.ptoPage(selectedPage);
                break;
            }
            case "newhire": 
            case "new_hire": 
            case "new-hire": {
                selectedPage = this.paginate(this.formAdminService.getNewHireSubmissionsByUser(id), (Pageable)pageable);
                builder.newHirePage(selectedPage);
                break;
            }
            case "perdiem": 
            case "per_diem": 
            case "per-diem": {
                selectedPage = this.paginate(this.formAdminService.getPerDiemSubmissionsByUser(id), (Pageable)pageable);
                builder.perDiemPage(selectedPage);
                break;
            }
            case "termination": {
                selectedPage = this.paginate(this.formAdminService.getTerminationSubmissionsByUser(id), (Pageable)pageable);
                builder.terminationPage(selectedPage);
                break;
            }
            case "targetorder": 
            case "target_order": 
            case "target-order": {
                selectedPage = this.paginate(this.formAdminService.getTargetOrderSubmissionsByUser(id), (Pageable)pageable);
                builder.targetOrderPage(selectedPage);
                break;
            }
            case "uniform": {
                selectedPage = this.paginate(this.formAdminService.getUniformSubmissionsByUser(id), (Pageable)pageable);
                builder.uniformPage(selectedPage);
                break;
            }
            case "workticket": 
            case "work_ticket": 
            case "work-ticket": {
                selectedPage = this.paginate(this.formAdminService.getWorkTicketSubmissionsByUser(id), (Pageable)pageable);
                builder.workTicketPage(selectedPage);
                break;
            }
            case "nonmnmileage": 
            case "non_mn_mileage": 
            case "non-mn-mileage": {
                selectedPage = this.paginate(this.formAdminService.getNonMnMileageSubmissionsByUser(id), (Pageable)pageable);
                builder.nonMnMileagePage(selectedPage);
                break;
            }
            default: {
                this.log.warn("Unknown formName '{}' for getFormsPaginatedByPortalUser.", (Object)formName);
                HashMap<String, Object> body = new HashMap<String, Object>();
                body.put("error", "Unknown formName");
                body.put("formName", formName);
                body.put("validOptions", Arrays.asList("backpay", "bonus", "hotel", "mileage", "pto", "newhire", "perdiem", "termination", "targetorder", "uniform", "workticket", "nonmnmileage"));
                return ResponseEntity.unprocessableEntity().body(body);
            }
        }
        builder.totalPages(selectedPage.getTotalPages()).totalElements(selectedPage.getTotalElements()).hasNext(selectedPage.hasNext()).hasPrevious(selectedPage.hasPrevious());
        this.log.info("Paginated '{}' forms for portal user ID {} retrieved successfully", (Object)formName, (Object)id);
        return ResponseEntity.ok((Object)builder.build());
    }
}

