/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.Hotel;
import com.cbmportal.portal.domains.HotelReason;
import com.cbmportal.portal.domains.MileageDate;
import com.cbmportal.portal.domains.NonMnMileage;
import com.cbmportal.portal.domains.PerDiem;
import com.cbmportal.portal.domains.TypeOfWork;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.domains.VO.HotelRequestDTO;
import com.cbmportal.portal.domains.VO.MileageDateDTO;
import com.cbmportal.portal.domains.VO.NonMnMileageRequestDTO;
import com.cbmportal.portal.domains.VO.PerDiemRequestDTO;
import com.cbmportal.portal.domains.VO.WorkTicketRequestDTO;
import com.cbmportal.portal.domains.WorkTicket;
import com.cbmportal.portal.repositories.EmployeeRepository;
import com.cbmportal.portal.repositories.PSRepository;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.StoreRepository;
import com.cbmportal.portal.services.HotelService;
import com.cbmportal.portal.services.NonMnMileageService;
import com.cbmportal.portal.services.PerDiemService;
import com.cbmportal.portal.services.WorkTicketService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/finance/"})
public class FinanceSubmissions {
    private final Logger log = LoggerFactory.getLogger(FinanceSubmissions.class);
    private final WorkTicketService workTicketService;
    private final HotelService hotelService;
    private final PerDiemService perDiemService;
    private final NonMnMileageService nonMnMileageService;
    private final PSRepository psRepository;

    public FinanceSubmissions(WorkTicketService workTicketService, HotelService hotelService, PerDiemService perDiemService, NonMnMileageService nonMnMileageService, EmployeeRepository employeeRepository, PortalUserRepository portalUserRepository, StoreRepository storeRepository, PSRepository psRepository) {
        this.workTicketService = workTicketService;
        this.hotelService = hotelService;
        this.perDiemService = perDiemService;
        this.nonMnMileageService = nonMnMileageService;
        this.psRepository = psRepository;
    }

    @PostMapping(value={"workTicketSubmit"})
    ResponseEntity<FormSubmissionResponse> workTicketSubmit(@RequestBody WorkTicketRequestDTO dto, HttpServletResponse response) {
        WorkTicket wt = new WorkTicket();
        wt.setCurrentLocation(dto.getCurrentLocation());
        wt.setProjectLocation(dto.getProjectLocation());
        wt.setEmployee(dto.getEmployee());
        wt.setPortalUser(dto.getPortalUser());
        if (wt.getCurrentLocation() == null || wt.getProjectLocation() == null) {
            return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("WorkTicket Form", false, new ApiError("submitWorkTicket", "Please fill in every field that has an * next to it.")));
        }
        try {
            if (dto.getTypeOfWork() != null) {
                wt.setTypeOfWork(TypeOfWork.fromString((String)dto.getTypeOfWork()));
            }
        }
        catch (IllegalArgumentException iae) {
            return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse("WorkTicket Form", false, new ApiError("submitWorkTicket", "Invalid typeOfWork: " + dto.getTypeOfWork())));
        }
        wt.setIsBillable(dto.getIsBillable());
        wt.setNotes(dto.getNotes());
        wt.setEquipmentNeeded(dto.getEquipmentNeeded());
        wt.setSupplyOrderDate(dto.getSupplyOrderDate());
        wt.setProjectStartDate(dto.getProjectStartDate());
        wt.setProjectEndDate(dto.getProjectEndDate());
        wt.setOrderNumber(dto.getOrderNumber());
        wt.setSupplyOrderSubmitted(dto.getSupplyOrderSubmitted());
        this.log.info("Mapped WorkTicket from DTO: {}", (Object)wt);
        try {
            return ResponseEntity.status((int)response.getStatus()).body((Object)this.workTicketService.processWorkTicket(wt, response));
        }
        catch (Exception exc) {
            this.log.error("Exception processing workTicketSubmit", (Throwable)exc);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
        }
    }

    @PostMapping(value={"hotelSubmit"})
    ResponseEntity<FormSubmissionResponse> hotelSubmit(@RequestBody HotelRequestDTO dto, HttpServletResponse response) {
        Hotel hotel = new Hotel();
        hotel.setPortalUser(dto.getPortalUser());
        hotel.setStore(dto.getStore());
        hotel.setCheckIn(dto.getCheckIn());
        hotel.setCheckOut(dto.getCheckOut());
        hotel.setNumOfRooms(dto.getNumOfRooms());
        hotel.setNumOfBeds(dto.getNumOfBeds());
        hotel.setNewPS(dto.getNewPS());
        hotel.setWorkTicket(dto.getWorkTicket());
        hotel.setComments(dto.getComments());
        if (dto.getPs1Id() != null) {
            this.psRepository.findById((Object)dto.getPs1Id()).ifPresent(arg_0 -> ((Hotel)hotel).setPs1(arg_0));
        }
        if (dto.getPs2Id() != null) {
            this.psRepository.findById((Object)dto.getPs2Id()).ifPresent(arg_0 -> ((Hotel)hotel).setPs2(arg_0));
        }
        if (dto.getHotelReason() != null) {
            try {
                hotel.setHotelReason(HotelReason.valueOf((String)dto.getHotelReason()));
            }
            catch (IllegalArgumentException iae) {
                return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse("Hotel Form", false, new ApiError("submitHotel", "Invalid hotelReason: " + dto.getHotelReason())));
            }
        }
        if (hotel.getStore() == null) {
            return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse("Hotel Form", false, new ApiError("submitHotel", "Store is required")));
        }
        try {
            return ResponseEntity.status((int)response.getStatus()).body((Object)this.hotelService.requestHotel(hotel, response));
        }
        catch (Exception exc) {
            this.log.error("Exception processing hotelSubmit", (Throwable)exc);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitHotel", exc.getMessage())));
        }
    }

    @PostMapping(value={"perDiemSubmit"})
    ResponseEntity<FormSubmissionResponse> perDiemSubmit(@RequestBody PerDiemRequestDTO dto, HttpServletResponse response) {
        PerDiem perDiem = new PerDiem();
        perDiem.setStore(dto.getStore());
        if (dto.getMileageDates() == null || dto.getMileageDates().isEmpty()) {
            return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse("PerDiem Form", false, new ApiError("submitPerDiem", "mileageDates are required")));
        }
        ArrayList<MileageDate> mdList = new ArrayList<MileageDate>();
        for (MileageDateDTO mdDto : dto.getMileageDates()) {
            MileageDate md = new MileageDate();
            md.setDate(mdDto.getDate());
            if (mdDto.getLocation1() != null) {
                md.setLocation1(mdDto.getLocation1());
            }
            if (mdDto.getLocation2() != null) {
                md.setLocation2(mdDto.getLocation2());
            }
            if (mdDto.getRt_ow() != null) {
                md.setRt_ow(mdDto.getRt_ow());
            }
            mdList.add(md);
        }
        perDiem.setMileageDates(mdList);
        perDiem.setFirstHotelNight(dto.getFirstHotelNight());
        perDiem.setLastHotelNight(dto.getLastHotelNight());
        perDiem.setArrivalDate(dto.getArrivalDate());
        perDiem.setDepartureDate(dto.getDepartureDate());
        perDiem.setReasonPayMissed(dto.getReasonPayMissed());
        perDiem.setEmployee(dto.getEmployee());
        perDiem.setPortalUser(dto.getPortalUser());
        try {
            return ResponseEntity.status((int)response.getStatus()).body((Object)this.perDiemService.processPerDiem(perDiem, response));
        }
        catch (Exception exc) {
            this.log.error("Exception processing perDiemSubmit", (Throwable)exc);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
        }
    }

    @PostMapping(value={"/nonMnMileageSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitMileage(@RequestBody NonMnMileageRequestDTO dto, HttpServletResponse response) {
        NonMnMileage mileage = new NonMnMileage();
        mileage.setComments(dto.getComments());
        mileage.setEmployee(dto.getEmployee());
        mileage.setPortalUser(dto.getPortalUser());
        if (mileage.getEmployee() == null) {
            return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse("Non MN Mileage Form", false, new ApiError("nonMnMileageSubmit", "employee is required")));
        }
        if (dto.getMileageDates() == null || dto.getMileageDates().isEmpty()) {
            return ResponseEntity.badRequest().body((Object)new FormSubmissionResponse("Non MN Mileage Form", false, new ApiError("nonMnMileageSubmit", "mileageDates are required")));
        }
        ArrayList<MileageDate> mdList = new ArrayList<MileageDate>();
        for (MileageDateDTO mdDto : dto.getMileageDates()) {
            MileageDate md = new MileageDate();
            md.setDate(mdDto.getDate());
            if (mdDto.getLocation1() != null) {
                md.setLocation1(mdDto.getLocation1());
            }
            if (mdDto.getLocation2() != null) {
                md.setLocation2(mdDto.getLocation2());
            }
            if (mdDto.getRt_ow() != null) {
                md.setRt_ow(mdDto.getRt_ow());
            }
            mdList.add(md);
        }
        mileage.setMileageDates(mdList);
        try {
            return ResponseEntity.status((int)response.getStatus()).body((Object)this.nonMnMileageService.processMileage(mileage, response));
        }
        catch (Exception exc) {
            this.log.error("Exception processing nonMnMileageSubmit", (Throwable)exc);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("nonMnMileageSubmit", exc.getMessage())));
        }
    }
}

