/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.utility;

import com.cbmportal.portal.utility.KeyGeneratorUtility;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RSAKeyProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSAKeyProperties.class);
    private static final String KEYS_DIRECTORY = "keys";
    private static final String PUBLIC_KEY_FILE = "public.key";
    private static final String PRIVATE_KEY_FILE = "private.key";
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;

    public RSAKeyProperties() {
        try {
            Path keysDir = Paths.get(KEYS_DIRECTORY, new String[0]);
            Path publicKeyPath = keysDir.resolve(PUBLIC_KEY_FILE);
            Path privateKeyPath = keysDir.resolve(PRIVATE_KEY_FILE);
            if (Files.exists(publicKeyPath, new LinkOption[0]) && Files.exists(privateKeyPath, new LinkOption[0])) {
                log.info("Loading existing RSA keys from filesystem");
                this.loadKeysFromFile(publicKeyPath, privateKeyPath);
                log.info("RSA keys loaded successfully from: {}", (Object)keysDir.toAbsolutePath());
                log.warn("SECURITY: Ensure {} directory has restricted access and is backed up securely", (Object)keysDir.toAbsolutePath());
            } else {
                log.info("No existing RSA keys found, generating new key pair");
                this.generateAndSaveKeys(keysDir, publicKeyPath, privateKeyPath);
                log.info("New RSA keys generated and saved successfully");
                log.warn("SECURITY: Protect the {} directory! Back up keys securely and restrict file permissions", (Object)keysDir.toAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error("Failed to initialize RSA keys, falling back to in-memory keys", (Throwable)e);
            KeyPair pair = KeyGeneratorUtility.generateRsaKey();
            this.publicKey = (RSAPublicKey)pair.getPublic();
            this.privateKey = (RSAPrivateKey)pair.getPrivate();
        }
    }

    private void loadKeysFromFile(Path publicKeyPath, Path privateKeyPath) throws Exception {
        byte[] publicKeyBytes = Files.readAllBytes(publicKeyPath);
        String publicKeyPEM = new String(publicKeyBytes).replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        byte[] publicKeyDecoded = Base64.getDecoder().decode(publicKeyPEM);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyDecoded);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        this.publicKey = (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        byte[] privateKeyBytes = Files.readAllBytes(privateKeyPath);
        String privateKeyPEM = new String(privateKeyBytes).replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] privateKeyDecoded = Base64.getDecoder().decode(privateKeyPEM);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyDecoded);
        this.privateKey = (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
    }

    private void generateAndSaveKeys(Path keysDir, Path publicKeyPath, Path privateKeyPath) throws Exception {
        if (!Files.exists(keysDir, new LinkOption[0])) {
            Files.createDirectories(keysDir, new FileAttribute[0]);
            log.debug("Created keys directory: {}", (Object)keysDir.toAbsolutePath());
        }
        KeyPair pair = KeyGeneratorUtility.generateRsaKey();
        this.publicKey = (RSAPublicKey)pair.getPublic();
        this.privateKey = (RSAPrivateKey)pair.getPrivate();
        String publicKeyPEM = "-----BEGIN PUBLIC KEY-----\n" + Base64.getEncoder().encodeToString(this.publicKey.getEncoded()) + "\n-----END PUBLIC KEY-----";
        Files.write(publicKeyPath, publicKeyPEM.getBytes(), new OpenOption[0]);
        log.debug("Public key saved to: {}", (Object)publicKeyPath.toAbsolutePath());
        String privateKeyPEM = "-----BEGIN PRIVATE KEY-----\n" + Base64.getEncoder().encodeToString(this.privateKey.getEncoded()) + "\n-----END PRIVATE KEY-----";
        Files.write(privateKeyPath, privateKeyPEM.getBytes(), new OpenOption[0]);
        try {
            this.setRestrictivePermissions(privateKeyPath);
            log.debug("Private key saved with restrictive permissions to: {}", (Object)privateKeyPath.toAbsolutePath());
        }
        catch (Exception e) {
            log.warn("Could not set restrictive file permissions on private key. Ensure manual protection of: {}", (Object)privateKeyPath.toAbsolutePath(), (Object)e);
        }
    }

    private void setRestrictivePermissions(Path privateKeyPath) throws Exception {
        try {
            PosixFilePermissions.fromString("rw-------");
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rw-------");
            Files.setPosixFilePermissions(privateKeyPath, perms);
            log.debug("Set POSIX permissions (rw-------) on private key");
        }
        catch (UnsupportedOperationException e) {
            log.debug("POSIX permissions not supported (likely Windows), file system security will apply");
        }
    }

    @Generated
    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public void setPublicKey(RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setPrivateKey(RSAPrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

