/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.config.SecurityProperties;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.RefreshToken;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.RefreshTokenRepository;
import com.cbmportal.portal.services.TokenService;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TokenServiceImpl
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenServiceImpl.class);
    private final JwtEncoder jwtEncoder;
    private final RefreshTokenRepository refreshTokenRepository;
    private final PortalUserRepository portalUserRepository;
    private final SecurityProperties securityProperties;
    private static final long ACCESS_TOKEN_VALIDITY = 900L;
    private static final long REFRESH_TOKEN_VALIDITY_NORMAL = 604800L;
    private static final long REFRESH_TOKEN_VALIDITY_REMEMBER_ME = 2592000L;

    public TokenServiceImpl(JwtEncoder jwtEncoder, RefreshTokenRepository refreshTokenRepository, PortalUserRepository portalUserRepository, SecurityProperties securityProperties) {
        this.jwtEncoder = jwtEncoder;
        this.refreshTokenRepository = refreshTokenRepository;
        this.portalUserRepository = portalUserRepository;
        this.securityProperties = securityProperties;
    }

    public String generateJwt(@NotNull Authentication auth) {
        log.debug("Generating JWT access token for user: {}", (Object)auth.getName());
        Instant expire = Instant.now().plusSeconds(900L);
        String scope = auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(" "));
        JwtClaimsSet claims = JwtClaimsSet.builder().issuer("cbmPortal").issuedAt(Instant.now()).expiresAt(expire).subject(auth.getName()).claim("userRole", (Object)scope).build();
        String token = this.jwtEncoder.encode(JwtEncoderParameters.from((JwtClaimsSet)claims)).getTokenValue();
        log.debug("JWT access token generated successfully, expires at: {}", (Object)expire);
        return token;
    }

    @Transactional
    public RefreshToken generateRefreshToken(@NotNull Authentication auth, boolean rememberMe, String deviceInfo, String ipAddress) {
        List activeTokens;
        log.info("Generating refresh token for user: {}, rememberMe: {}", (Object)auth.getName(), (Object)rememberMe);
        PortalUser user = (PortalUser)this.portalUserRepository.findPortalUserByUserName(auth.getName()).orElseThrow(() -> new IllegalArgumentException("User not found: " + auth.getName()));
        int maxSessions = this.securityProperties.getMaxSessionsPerUser();
        if (maxSessions > 0 && (activeTokens = this.refreshTokenRepository.findByUserAndRevokedFalseAndExpiresAtAfter(user, Instant.now())).size() >= maxSessions) {
            log.info("User {} has {} active sessions, exceeding max {}. Revoking oldest sessions.", new Object[]{user.getUsername(), activeTokens.size(), maxSessions});
            activeTokens.sort((a, b) -> {
                Instant aTime;
                Instant instant = a.getCreatedAt() != null ? a.getCreatedAt() : (aTime = a.getLastUsedAt() != null ? a.getLastUsedAt() : a.getExpiresAt());
                Instant bTime = b.getCreatedAt() != null ? b.getCreatedAt() : (b.getLastUsedAt() != null ? b.getLastUsedAt() : b.getExpiresAt());
                return aTime.compareTo(bTime);
            });
            int toRevoke = activeTokens.size() - maxSessions + 1;
            for (int i = 0; i < toRevoke && i < activeTokens.size(); ++i) {
                RefreshToken old = (RefreshToken)activeTokens.get(i);
                old.setRevoked(true);
                this.refreshTokenRepository.save((Object)old);
                log.info("Revoked old session token {} for user {} due to maxSessionsPerUser policy", (Object)old.getId(), (Object)user.getUsername());
            }
        }
        String tokenValue = UUID.randomUUID().toString();
        long validity = rememberMe ? 2592000L : 604800L;
        Instant expiresAt = Instant.now().plusSeconds(validity);
        RefreshToken refreshToken = new RefreshToken(tokenValue, user, expiresAt);
        refreshToken.setDeviceInfo(deviceInfo);
        refreshToken.setIpAddress(ipAddress);
        RefreshToken saved = (RefreshToken)this.refreshTokenRepository.save((Object)refreshToken);
        log.info("Refresh token created for user: {}, expires at: {}", (Object)auth.getName(), (Object)expiresAt);
        return saved;
    }

    @Transactional(readOnly=true)
    public Authentication validateRefreshToken(@NotNull String token) {
        log.debug("Validating refresh token");
        RefreshToken refreshToken = (RefreshToken)this.refreshTokenRepository.findByToken(token).orElseThrow(() -> {
            log.warn("Refresh token not found");
            return new IllegalArgumentException("Invalid refresh token");
        });
        if (!refreshToken.isValid()) {
            log.warn("Refresh token is invalid (revoked or expired) for user: {}", (Object)refreshToken.getUser().getUsername());
            throw new IllegalArgumentException("Refresh token is expired or revoked");
        }
        refreshToken.setLastUsedAt(Instant.now());
        this.refreshTokenRepository.save((Object)refreshToken);
        PortalUser user = refreshToken.getUser();
        log.debug("Refresh token validated successfully for user: {}", (Object)user.getUsername());
        return new UsernamePasswordAuthenticationToken((Object)user.getUsername(), null, (Collection)user.getAuthorities());
    }

    @Transactional
    public void revokeRefreshToken(@NotNull String token) {
        log.info("Revoking refresh token");
        RefreshToken refreshToken = (RefreshToken)this.refreshTokenRepository.findByToken(token).orElseThrow(() -> new IllegalArgumentException("Refresh token not found"));
        refreshToken.setRevoked(true);
        this.refreshTokenRepository.save((Object)refreshToken);
        log.info("Refresh token revoked for user: {}", (Object)refreshToken.getUser().getUsername());
    }

    @Transactional
    public void revokeAllUserTokens(@NotNull String username) {
        log.info("Revoking all refresh tokens for user: {}", (Object)username);
        PortalUser user = (PortalUser)this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new IllegalArgumentException("User not found: " + username));
        this.refreshTokenRepository.findByUser(user).forEach(token -> {
            token.setRevoked(true);
            this.refreshTokenRepository.save(token);
        });
        log.info("All refresh tokens revoked for user: {}", (Object)username);
    }
}

