/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Termination;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.TerminationRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.TerminationService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TerminationServiceImpl
implements TerminationService {
    private final Logger log = LoggerFactory.getLogger(TerminationServiceImpl.class);
    private final TerminationRepository terminationRepository;
    private final PdfBuilderService pdfBuilderService;
    private final CustomProperties customProperties;
    private final MicrosoftGraphEmailService emailService;
    private final PdfStorageHelper pdfStorageHelper;
    private final String htmlFormLocation;

    public TerminationServiceImpl(TerminationRepository terminationRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        this.terminationRepository = terminationRepository;
        this.pdfBuilderService = pdfBuilderService;
        this.emailService = emailService;
        this.htmlFormLocation = htmlFormLocation;
        this.customProperties = customProperties;
        this.pdfStorageHelper = pdfStorageHelper;
    }

    public FormSubmissionResponse processTermination(Termination termination, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File terminationHtml = new File(this.htmlFormLocation + "termination.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = termination.getEmployee().getEmployeeFirst() + " " + termination.getEmployee().getEmployeeLast();
        String pdfFileName = "termination-" + termination.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String base = this.customProperties.getPdfFiles();
        if (base == null || base.isBlank()) {
            throw new IOException("cbm.pdfFiles configuration is missing");
        }
        String pdfSaveLocation = this.pdfStorageHelper.buildAndPrepare(base, new String[]{"termination", termination.getEmployee().getEmployeeNumber().toString()});
        Document doc = Jsoup.parse((File)terminationHtml, (String)"UTF-8", (String)"");
        TerminationServiceImpl.wereWarningsGiven((Termination)termination, (Document)doc);
        TerminationServiceImpl.wasTwoWeeksGiven((Termination)termination, (Document)doc);
        TerminationServiceImpl.isEligibleForRehire((Termination)termination, (Document)doc);
        doc.getElementsByClass("employeeNum").html(termination.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeFirstName").html(termination.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeLastName").html(termination.getEmployee().getEmployeeLast());
        doc.getElementsByClass("employeeSecondLastName").html(termination.getEmployee().getEmployeeSecondLast());
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("lastDayWorked").html(dateFormatter.format(termination.getLastDayWorked()));
        doc.getElementsByClass("termType").html(termination.getTermType().getTermType());
        TerminationServiceImpl.didNoShowFirstDay((Termination)termination, (Document)doc);
        doc.getElementsByClass("dm").html(termination.getPortalUser().getUserFirst() + " " + termination.getPortalUser().getUserLast());
        try {
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                String termEmail = (String)this.customProperties.getDepartmentEmails().get("Terminations");
                if (termEmail == null || termEmail.isBlank()) {
                    throw new IllegalStateException("Missing cbm.departmentEmails.Terminations configuration for Termination");
                }
                List<String> recipients = List.of(termEmail, termination.getPortalUser().getEmail());
                String subject = "Termination Form - " + fullEmployeeName;
                String htmlBody = "<html><body><h3>Termination Form Submission</h3><p>Please find attached the termination form for employee: <strong>" + fullEmployeeName + "</strong></p><p>Employee Number: " + termination.getEmployee().getEmployeeNumber() + "</p><p>Last Day Worked: " + dateFormatter.format(termination.getLastDayWorked()) + "</p></body></html>";
                this.emailService.sendEmail(recipients, subject, htmlBody, f);
                response.setStatus(HttpStatus.OK.value());
                termination.setSubmittedDate(LocalDateTime.now());
                Termination savedTerm = (Termination)this.terminationRepository.save((Object)termination);
                if (savedTerm.getId() != null) {
                    formResponse.setFormName("Termination Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/hr/termSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Termination Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    private static void didNoShowFirstDay(Termination termination, Document doc) {
        if (!Objects.equals(termination.getTermType().toString(), "noShowFirstDay")) {
            doc.getElementsByClass("quitReason").html("<td>Reason employee quit: " + termination.getQuitReason() + "</td>");
        } else {
            doc.getElementsByClass("quitReason").html("<td>Reason employee quit: N/A</td>");
        }
    }

    private static void wereWarningsGiven(Termination termination, Document doc) {
        if (Objects.equals(termination.getTermType().toString(), "Other")) {
            if (termination.getWarningsGiven().booleanValue()) {
                doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">Yes</span> ");
            } else {
                doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">No</span> ");
            }
        } else {
            doc.getElementsByClass("warningsGiven").html("<span class=\"warningsGiven\">N/A</span> ");
        }
    }

    private static void wasTwoWeeksGiven(Termination termination, Document doc) {
        if (Objects.equals(termination.getTermType().toString(), "twoWeeks")) {
            if (termination.getTwoWeeksGiven().booleanValue()) {
                doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">Yes</span> </td>");
            } else {
                doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">No</span> </td>");
            }
        } else {
            doc.getElementsByClass("twoWeeks").html("<td> Was two weeks given: <span class=\"twoWeeks\">N/A</span> </td>");
        }
    }

    private static void isEligibleForRehire(Termination termination, Document doc) {
        if (termination.getEligibleRehire().booleanValue()) {
            doc.getElementsByClass("eligibleRehire").html("Eligible for rehire: Yes");
        } else {
            doc.getElementsByClass("eligibleRehire").html("Eligible for rehire: No");
        }
    }
}

