/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.configurations.CustomProperties;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.VO.FormContext;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.FormProcessingException;
import com.cbmportal.portal.repositories.PtoRepository;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.PtoService;
import com.cbmportal.portal.services.impl.AbstractFormProcessingService;
import com.cbmportal.portal.services.impl.MicrosoftGraphEmailService;
import com.cbmportal.portal.services.util.PdfStorageHelper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PtoServiceImpl
extends AbstractFormProcessingService<Pto>
implements PtoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PtoServiceImpl.class);
    private final CustomProperties customProperties;

    public PtoServiceImpl(PtoRepository ptoRepository, PdfBuilderService pdfBuilderService, MicrosoftGraphEmailService emailService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, CustomProperties customProperties, PdfStorageHelper pdfStorageHelper) {
        super(pdfBuilderService, emailService, (JpaRepository)ptoRepository, htmlFormLocation, customProperties, pdfStorageHelper);
        this.customProperties = customProperties;
    }

    public FormSubmissionResponse processPto(Pto pto) {
        return this.processForm((Object)pto);
    }

    protected void validateFormData(Pto pto) {
        if (pto == null) {
            throw new FormProcessingException("PTO data cannot be null");
        }
        if (pto.getEmployee() == null || pto.getEmployee().getEmployeeNumber() == null) {
            throw new FormProcessingException("Employee information is required");
        }
        if (pto.getPortalUser() == null) {
            throw new FormProcessingException("Portal user information is required");
        }
        if (pto.getDepartment() == null) {
            throw new FormProcessingException("Department information is required");
        }
        if (pto.getAbsenceFrom() == null || pto.getAbsenceTo() == null) {
            throw new FormProcessingException("Absence dates are required");
        }
    }

    protected FormContext buildFormContext(Pto pto) {
        String fullEmployeeName = pto.getEmployee().getEmployeeFirst() + " " + pto.getEmployee().getEmployeeLast();
        String empNum = pto.getEmployee().getEmployeeNumber().toString();
        String payrollEmail = (String)this.customProperties.getDepartmentEmails().get("Payroll");
        if (payrollEmail == null || payrollEmail.isBlank()) {
            throw new IllegalStateException("Missing cbm.departmentEmails.Payroll configuration for Back Pay");
        }
        return FormContext.builder().employeeName(fullEmployeeName).employeeNumber(empNum).pdfFileName("pto-" + empNum + "-" + this.dateFormatter.format(LocalDate.now()) + ".pdf").pdfSaveLocation(this.buildPdfSaveLocation(new String[]{"pto", empNum})).recipients(List.of(payrollEmail, pto.getPortalUser().getEmail())).emailSubject("PTO Form - " + fullEmployeeName).emailBody(this.buildEmailBody(fullEmployeeName, empNum, pto.getDepartment().getDepartment())).portalUserName(pto.getPortalUser().getUserFirst() + " " + pto.getPortalUser().getUserLast()).comments(pto.getComments()).formType("PTO").build();
    }

    protected Document generateHtmlDocument(FormContext context, Pto pto) throws IOException {
        File ptoHtml = new File(this.htmlFormLocation + "pto.html");
        Document doc = Jsoup.parse((File)ptoHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("absenceFrom").html(this.dateFormatter.format(pto.getAbsenceFrom()));
        doc.getElementsByClass("absenceTo").html(this.dateFormatter.format(pto.getAbsenceTo()));
        doc.getElementsByClass("service").html(pto.getDepartment().getDepartment());
        doc.getElementsByClass("employeeNum").html(context.getEmployeeNumber());
        doc.getElementsByClass("employeeName").html(context.getEmployeeName());
        doc.getElementsByClass("currentDate").html(this.dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("hours").html(pto.getHours().toString());
        doc.getElementsByClass("comments").html(context.getComments() != null ? context.getComments() : "");
        doc.getElementsByClass("dmSig").html("<img src=" + pto.getSig() + " alt=\"Signature\" />");
        doc.getElementsByClass("dm").html(context.getPortalUserName());
        return doc;
    }

    protected String getFormName() {
        return "PTO Form";
    }

    protected Long getEntityId(Pto entity) {
        return entity.getId();
    }

    protected void setSubmittedDate(Pto pto) {
        pto.setSubmittedDate(LocalDateTime.now());
    }

    private String buildEmailBody(String employeeName, String employeeNumber, String department) {
        return "<html><body><h3>PTO Form Submission</h3><p>Please find attached the PTO form for employee: <strong>" + employeeName + "</strong></p><p>Employee Number: " + employeeNumber + "</p><p>Department: " + department + "</p></body></html>";
    }
}

