/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.UserRole;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.cbmportal.portal.exceptions.DatabaseOperationException;
import com.cbmportal.portal.exceptions.ResourceNotFoundException;
import com.cbmportal.portal.exceptions.ValidationException;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.UserRoleRepository;
import com.cbmportal.portal.services.PortalUserService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalUserServiceImpl
implements UserDetailsService,
PortalUserService {
    final Logger log = LoggerFactory.getLogger(PortalUserServiceImpl.class);
    private final PortalUserRepository portalUserRepository;
    private final UserRoleRepository userRoleRepository;

    public PortalUserServiceImpl(PortalUserRepository portalUserRepository, UserRoleRepository userRoleRepository) {
        this.portalUserRepository = portalUserRepository;
        this.userRoleRepository = userRoleRepository;
    }

    public PortalUser createPortalUser(PortalUser portalUser) {
        try {
            this.log.info("Creating portal user: {} with permission: {}", (Object)portalUser.getUsername(), (Object)portalUser.getPermission());
            portalUser.setPermission(this.permissionCheck(portalUser.getPermission().toString()));
            if (portalUser.getAuthorities() == null) {
                portalUser.setAuthorities(new HashSet());
            }
            PortalUser savedUser = (PortalUser)this.portalUserRepository.save((Object)portalUser);
            this.log.info("Portal user created successfully: {} (ID: {})", (Object)savedUser.getUsername(), (Object)savedUser.getId());
            return savedUser;
        }
        catch (DataAccessException dExc) {
            this.log.error("Failed to create portal user: {}", (Object)portalUser.getUsername(), (Object)dExc);
            throw new DatabaseOperationException("Failed to create portal user", (Throwable)dExc);
        }
    }

    private UserPermission permissionCheck(String permission) {
        if (Objects.equals(permission, UserPermission.Admin.toString())) {
            return UserPermission.Admin;
        }
        if (Objects.equals(permission, UserPermission.Office.toString())) {
            return UserPermission.Office;
        }
        if (Objects.equals(permission, UserPermission.DM.toString())) {
            return UserPermission.DM;
        }
        return UserPermission.PS;
    }

    @Transactional(readOnly=true)
    public PortalUser getDm(String userName) {
        this.log.debug("Fetching portal user: {}", (Object)userName);
        PortalUser user = (PortalUser)this.portalUserRepository.findPortalUserByUserName(userName).orElseThrow(() -> {
            this.log.warn("Portal user not found: {}", (Object)userName);
            return new ResourceNotFoundException("PortalUser", "username", (Object)userName);
        });
        this.log.debug("User {} has {} authorities", (Object)userName, (Object)user.getAuthorities().size());
        return user;
    }

    public PortalUserSafeVO updatePortalUser(PortalUser portalUser) {
        try {
            this.log.info("Updating portal user with ID: {}", (Object)portalUser.getId());
            PortalUser existingUser = (PortalUser)this.portalUserRepository.findById((Object)portalUser.getId()).orElseThrow(() -> {
                this.log.warn("Portal user not found with ID: {}", (Object)portalUser.getId());
                return new ResourceNotFoundException("PortalUser", "id", (Object)portalUser.getId().toString());
            });
            existingUser.setUserFirst(portalUser.getUserFirst());
            existingUser.setUserLast(portalUser.getUserLast());
            existingUser.setEmail(portalUser.getEmail());
            existingUser.setPermission(portalUser.getPermission());
            existingUser.setDistrict(portalUser.getDistrict());
            existingUser.setAuthorities(portalUser.getAuthorities());
            existingUser.setDisabled(portalUser.getDisabled());
            PortalUser updatedUser = (PortalUser)this.portalUserRepository.save((Object)existingUser);
            this.log.info("Portal user updated successfully: {} (ID: {})", (Object)updatedUser.getUsername(), (Object)updatedUser.getId());
            PortalUserSafeVO portalUserSafeVO = new PortalUserSafeVO();
            portalUserSafeVO.setUserFirst(updatedUser.getUserFirst());
            portalUserSafeVO.setUserLast(updatedUser.getUserLast());
            portalUserSafeVO.setId(updatedUser.getId());
            portalUserSafeVO.setEmail(updatedUser.getEmail());
            portalUserSafeVO.setUserName(updatedUser.getUsername());
            portalUserSafeVO.setAuthorities(updatedUser.getAuthorities() == null ? Collections.emptySet() : updatedUser.getAuthorities().stream().map(UserRole::getAuthority).collect(Collectors.toSet()));
            return portalUserSafeVO;
        }
        catch (DataAccessException dExc) {
            this.log.error("Failed to update portal user with ID: {}", (Object)portalUser.getId(), (Object)dExc);
            throw new DatabaseOperationException("Failed to update portal user", (Throwable)dExc);
        }
    }

    public List<PortalUser> getAllPortalUsers() {
        this.log.debug("Fetching all active portal users");
        List users = this.portalUserRepository.findByDisabledFalse();
        this.log.info("Retrieved {} active portal users", (Object)users.size());
        return users;
    }

    public PortalUser disablePortalUser(Long userId) {
        this.log.info("Disabling portal user with ID: {}", (Object)userId);
        PortalUser user = (PortalUser)this.portalUserRepository.findById((Object)userId).orElseThrow(() -> {
            this.log.warn("Portal user not found with ID: {}", (Object)userId);
            return new ResourceNotFoundException("PortalUser", "id", (Object)userId.toString());
        });
        user.setDisabled(Boolean.valueOf(true));
        PortalUser disabledUser = (PortalUser)this.portalUserRepository.save((Object)user);
        this.log.info("Portal user disabled successfully: {} (ID: {})", (Object)user.getUsername(), (Object)userId);
        return disabledUser;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return (UserDetails)this.portalUserRepository.findPortalUserByUserName(username).orElseThrow(() -> new UsernameNotFoundException("Your username/password was not found."));
    }

    public PortalUser assignAuthorities(Long userId, List<String> authorityNames) {
        PortalUser user = (PortalUser)this.portalUserRepository.findById((Object)userId).orElseThrow(() -> new ResourceNotFoundException("PortalUser", "id", (Object)userId.toString()));
        if (authorityNames == null || authorityNames.isEmpty()) {
            throw new ValidationException("At least one authority must be provided");
        }
        List<String> missing = authorityNames.stream().filter(name -> this.userRoleRepository.findByAuthority(name).isEmpty()).toList();
        if (!missing.isEmpty()) {
            throw new ValidationException("Unknown authorities: " + String.join((CharSequence)", ", missing));
        }
        if (user.getAuthorities() == null) {
            user.setAuthorities(new HashSet());
        }
        authorityNames.forEach(name -> this.userRoleRepository.findByAuthority(name).ifPresent(role -> {
            if (user.getAuthorities().stream().noneMatch(r -> r.getAuthority().equals(role.getAuthority()))) {
                user.getAuthorities().add(role);
            }
        }));
        PortalUser saved = (PortalUser)this.portalUserRepository.save((Object)user);
        this.log.info("Assigned authorities {} to user {}", authorityNames, (Object)saved.getUsername());
        return saved;
    }

    public PortalUser replaceAuthorities(Long userId, List<String> authorityNames) {
        boolean hasAdmin;
        PortalUser user = (PortalUser)this.portalUserRepository.findById((Object)userId).orElseThrow(() -> new ResourceNotFoundException("PortalUser", "id", (Object)userId.toString()));
        if (authorityNames == null) {
            throw new ValidationException("Authorities list must not be null");
        }
        boolean bl = hasAdmin = user.getAuthorities() != null && user.getAuthorities().stream().anyMatch(r -> "Admin".equals(r.getAuthority()));
        if (hasAdmin && authorityNames.stream().noneMatch(a -> "Admin".equals(a))) {
            throw new ValidationException("Cannot remove 'Admin' authority from an administrative user");
        }
        List<String> missing = authorityNames.stream().filter(name -> this.userRoleRepository.findByAuthority(name).isEmpty()).toList();
        if (!missing.isEmpty()) {
            throw new ValidationException("Unknown authorities: " + String.join((CharSequence)", ", missing));
        }
        HashSet newSet = new HashSet();
        authorityNames.forEach(name -> this.userRoleRepository.findByAuthority(name).ifPresent(newSet::add));
        user.setAuthorities(newSet);
        PortalUser saved = (PortalUser)this.portalUserRepository.save((Object)user);
        this.log.info("Replaced authorities with {} for user {}", authorityNames, (Object)saved.getUsername());
        return saved;
    }
}

