/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.PortalUser;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import lombok.Generated;

@Entity
@Table(name="refresh_tokens")
public class RefreshToken {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="refresh_token_seq")
    @SequenceGenerator(name="refresh_token_seq", sequenceName="refresh_token_seq", allocationSize=1)
    private Long id;
    @Column(nullable=false, unique=true, length=500)
    private String token;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private PortalUser user;
    @Column(nullable=false)
    private Instant expiresAt;
    @Column(nullable=false)
    private Instant createdAt;
    private Instant lastUsedAt;
    @Column(nullable=false)
    private boolean revoked = false;
    private String deviceInfo;
    private String ipAddress;

    public RefreshToken(String token, PortalUser user, Instant expiresAt) {
        this.token = token;
        this.user = user;
        this.expiresAt = expiresAt;
        this.createdAt = Instant.now();
        this.revoked = false;
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.expiresAt);
    }

    public boolean isValid() {
        return !this.revoked && !this.isExpired();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public PortalUser getUser() {
        return this.user;
    }

    @Generated
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getLastUsedAt() {
        return this.lastUsedAt;
    }

    @Generated
    public boolean isRevoked() {
        return this.revoked;
    }

    @Generated
    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setUser(PortalUser user) {
        this.user = user;
    }

    @Generated
    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastUsedAt(Instant lastUsedAt) {
        this.lastUsedAt = lastUsedAt;
    }

    @Generated
    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    @Generated
    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public RefreshToken() {
    }
}

