/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import lombok.Generated;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class District {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="district_id_seq")
    @SequenceGenerator(name="district_id_seq", sequenceName="DISTRICT_SEQUENCE", allocationSize=1)
    private Long id;
    @JsonProperty
    private String districtName;
    @JsonIgnore
    @ManyToMany
    private List<PortalUser> portalUsers;
    @JsonProperty
    @ManyToMany
    @Cascade(value={CascadeType.ALL})
    private List<PS> psList;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Store store;

    public District() {
    }

    public District(String districtName) {
        this.districtName = districtName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        District district1 = (District)o;
        return Objects.equals(this.id, district1.id) && Objects.equals(this.districtName, district1.districtName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.districtName);
    }

    public String toString() {
        return new StringJoiner(", ", District.class.getSimpleName() + "[", "]").add("id=" + this.id).add("districtName='" + this.districtName + "'").toString();
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    @JsonIgnore
    @Generated
    public void setPortalUsers(List<PortalUser> portalUsers) {
        this.portalUsers = portalUsers;
    }

    @JsonProperty
    @Generated
    public void setPsList(List<PS> psList) {
        this.psList = psList;
    }

    @JsonProperty
    @Generated
    public void setStore(Store store) {
        this.store = store;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDistrictName() {
        return this.districtName;
    }

    @Generated
    public List<PortalUser> getPortalUsers() {
        return this.portalUsers;
    }

    @Generated
    public List<PS> getPsList() {
        return this.psList;
    }

    @Generated
    public Store getStore() {
        return this.store;
    }
}

