/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.exceptions.ValidationException;
import com.cbmportal.portal.services.BackPayService;
import com.cbmportal.portal.services.BonusService;
import com.cbmportal.portal.services.MileageService;
import com.cbmportal.portal.services.PtoService;
import com.cbmportal.portal.services.TimeAdjustmentService;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/payroll"})
public class PayrollSubmissions {
    private final Logger log = LoggerFactory.getLogger(PayrollSubmissions.class);
    private final BackPayService backPayService;
    private final BonusService bonusService;
    private final MileageService mileageService;
    private final TimeAdjustmentService timeAdjustmentService;
    private final PtoService ptoService;

    public PayrollSubmissions(BackPayService backPayService, BonusService bonusService, MileageService mileageService, TimeAdjustmentService timeAdjustmentService, PtoService ptoService) {
        this.backPayService = backPayService;
        this.bonusService = bonusService;
        this.mileageService = mileageService;
        this.timeAdjustmentService = timeAdjustmentService;
        this.ptoService = ptoService;
    }

    @PostMapping(value={"/backPaySubmit"})
    public ResponseEntity<FormSubmissionResponse> submitBackPay(@RequestBody @NotNull BackPay backPay) {
        this.log.info("Back pay submission received for employee: {}", backPay.getEmployee() != null ? backPay.getEmployee().getEmployeeNumber() : "unknown");
        this.validateBackPay(backPay);
        FormSubmissionResponse response = this.backPayService.processBackPay(backPay);
        this.log.info("Back pay processed successfully for employee: {}", (Object)backPay.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    private void validateBackPay(BackPay backPay) {
        if (backPay.getBackPayDates() == null || backPay.getBackPayDates().isEmpty()) {
            throw new ValidationException("Back pay dates are required");
        }
        if (backPay.getEmployee() == null) {
            throw new ValidationException("Employee information is required");
        }
        if (backPay.getPortalUser() == null) {
            throw new ValidationException("Portal user information is required");
        }
    }

    @PostMapping(value={"/bonusSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitBonus(@RequestBody @NotNull Bonus bonus) {
        this.log.info("Bonus submission received for employee: {}", bonus.getEmployee() != null ? bonus.getEmployee().getEmployeeNumber() : "unknown");
        this.validateBonus(bonus);
        FormSubmissionResponse response = this.bonusService.processBonus(bonus);
        this.log.info("Bonus processed successfully for employee: {}", (Object)bonus.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    private void validateBonus(Bonus bonus) {
        if (bonus.getBonuses() == null || bonus.getBonuses().isEmpty()) {
            throw new ValidationException("Bonus information is required");
        }
        if (bonus.getEmployee() == null) {
            throw new ValidationException("Employee information is required");
        }
        if (bonus.getPortalUser() == null) {
            throw new ValidationException("Portal user information is required");
        }
    }

    @PostMapping(value={"/mileageSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitMileage(@RequestBody @NotNull Mileage mileage) {
        this.log.info("Mileage submission received for employee: {}", mileage.getEmployee() != null ? mileage.getEmployee().getEmployeeNumber() : "unknown");
        this.validateMileage(mileage);
        FormSubmissionResponse response = this.mileageService.processMileage(mileage);
        this.log.info("Mileage processed successfully for employee: {}", (Object)mileage.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    private void validateMileage(Mileage mileage) {
        if (mileage.getMileageDates() == null || mileage.getMileageDates().isEmpty()) {
            throw new ValidationException("Mileage dates are required");
        }
        if (mileage.getEmployee() == null) {
            throw new ValidationException("Employee information is required");
        }
        if (mileage.getPortalUser() == null) {
            throw new ValidationException("Portal user information is required");
        }
    }

    @PostMapping(value={"/ptoSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitPto(@RequestBody @NotNull Pto pto) {
        this.log.info("PTO submission received for employee: {}", pto.getEmployee() != null ? pto.getEmployee().getEmployeeNumber() : "unknown");
        this.validatePto(pto);
        FormSubmissionResponse response = this.ptoService.processPto(pto);
        this.log.info("PTO processed successfully for employee: {}", (Object)pto.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    private void validatePto(Pto pto) {
        if (pto.getHours() == null || pto.getHours() <= 0.0) {
            throw new ValidationException("Valid hours are required");
        }
        if (pto.getAbsenceFrom() == null) {
            throw new ValidationException("Absence from date is required");
        }
        if (pto.getAbsenceTo() == null) {
            throw new ValidationException("Absence to date is required");
        }
        if (pto.getEmployee() == null) {
            throw new ValidationException("Employee information is required");
        }
        if (pto.getDepartment() == null || Objects.equals(pto.getDepartment().getDepartment(), "")) {
            throw new ValidationException("Department is required");
        }
        if (pto.getSig() == null) {
            throw new ValidationException("Signature is required");
        }
        if (pto.getPortalUser() == null) {
            throw new ValidationException("Portal user information is required");
        }
    }

    @PostMapping(value={"/timeAdjustmentSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitTimeAdjustment(@RequestBody @NotNull TimeAdjustment timeAdjustment) {
        this.log.info("Time adjustment submission received for employee: {}", timeAdjustment.getEmployee() != null ? timeAdjustment.getEmployee().getEmployeeNumber() : "unknown");
        this.validateTimeAdjustment(timeAdjustment);
        FormSubmissionResponse response = this.timeAdjustmentService.processTimeAdjustment(timeAdjustment);
        this.log.info("Time adjustment processed successfully for employee: {}", (Object)timeAdjustment.getEmployee().getEmployeeNumber());
        return ResponseEntity.ok((Object)response);
    }

    private void validateTimeAdjustment(TimeAdjustment timeAdjustment) {
        if (timeAdjustment.getBreaks() == null || timeAdjustment.getBreaks().isEmpty()) {
            throw new ValidationException("Break information is required");
        }
        if (timeAdjustment.getEmployee() == null) {
            throw new ValidationException("Employee information is required");
        }
        if (timeAdjustment.getPortalUser() == null) {
            throw new ValidationException("Portal user information is required");
        }
        if (timeAdjustment.getEmployeeSig() == null) {
            throw new ValidationException("Employee signature is required");
        }
        if (timeAdjustment.getManagerSig() == null) {
            throw new ValidationException("Manager signature is required");
        }
    }
}

