/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.controllers.Admin;
import com.cbmportal.portal.domains.PS;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.VO.DistrictSafeVO;
import com.cbmportal.portal.domains.VO.PortalUserSafeVO;
import com.cbmportal.portal.exceptions.ValidationException;
import com.cbmportal.portal.repositories.DistrictRepository;
import com.cbmportal.portal.services.PSService;
import com.cbmportal.portal.services.PortalUserService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin"})
@CrossOrigin
@PreAuthorize(value="hasAnyAuthority('Admin','Office','DM')")
public class Admin {
    private final Logger log = LoggerFactory.getLogger(Admin.class);
    private final PortalUserService portalUserService;
    private final PSService psService;
    private final DistrictRepository districtRepository;

    public Admin(PortalUserService portalUserService, PSService psService, DistrictRepository districtRepository) {
        this.portalUserService = portalUserService;
        this.psService = psService;
        this.districtRepository = districtRepository;
    }

    @GetMapping(value={"/getPortalUsers"})
    public ResponseEntity<List<PortalUser>> getAllPortalUsers() {
        this.log.info("Fetching all portal users");
        List users = this.portalUserService.getAllPortalUsers();
        this.log.debug("Retrieved {} portal users", (Object)users.size());
        return ResponseEntity.ok((Object)users);
    }

    @GetMapping(value={"/getPortalUser"})
    public ResponseEntity<PortalUser> getPortalUser(@RequestParam(value="userName") String username) {
        if (username == null || username.trim().isEmpty()) {
            this.log.warn("Get portal user request with empty username");
            throw new ValidationException("Username is required");
        }
        this.log.info("Fetching portal user: {}", (Object)username);
        PortalUser retrievedUser = this.portalUserService.getDm(username);
        this.log.debug("Portal user retrieved successfully: {}", (Object)username);
        return ResponseEntity.ok((Object)retrievedUser);
    }

    @PostMapping(value={"/createPortalUser"})
    public ResponseEntity<PortalUser> createPortalUser(@RequestBody PortalUser portalUser) {
        this.validatePortalUser(portalUser);
        this.log.info("Creating portal user: {}", (Object)portalUser.getUsername());
        PortalUser savedUser = this.portalUserService.createPortalUser(portalUser);
        this.log.info("Portal user created successfully: {} with permission: {}", (Object)savedUser.getUsername(), (Object)savedUser.getPermission());
        return ResponseEntity.ok((Object)savedUser);
    }

    @PostMapping(value={"/createPS"})
    public ResponseEntity<PS> createPS(@RequestBody PS ps) {
        if (ps == null) {
            this.log.warn("Create PS request with null PS data");
            throw new ValidationException("PS data is required");
        }
        this.log.info("Creating PS: {}", (Object)ps.getFirstName());
        PS savedPS = this.psService.createPS(ps);
        this.log.info("PS created successfully: {}", (Object)savedPS.getFirstName());
        return ResponseEntity.ok((Object)savedPS);
    }

    @PutMapping(value={"/updatePortalUser"})
    public ResponseEntity<PortalUserSafeVO> updatePortalUser(@RequestBody PortalUser portalUser) {
        this.validatePortalUserForUpdate(portalUser);
        this.log.info("Updating portal user with ID: {}", (Object)portalUser.getId());
        PortalUserSafeVO updatedUser = this.portalUserService.updatePortalUser(portalUser);
        this.log.info("Portal user updated successfully: {}", (Object)updatedUser.getUserName());
        return ResponseEntity.ok((Object)updatedUser);
    }

    @PutMapping(value={"/updatePS"})
    public ResponseEntity<PS> updatePS(@RequestBody PS ps) {
        if (ps == null) {
            this.log.warn("Update PS request with null PS data");
            throw new ValidationException("PS data is required");
        }
        this.log.info("Updating PS: {}", (Object)ps.getFirstName());
        PS updatedPS = this.psService.updatePS(ps);
        PortalUserSafeVO portalUserSafeVO = new PortalUserSafeVO();
        portalUserSafeVO.setUserName(updatedPS.getPortalUser().getUsername());
        portalUserSafeVO.setId(updatedPS.getPortalUser().getId());
        portalUserSafeVO.setUserFirst(updatedPS.getPortalUser().getUserFirst());
        portalUserSafeVO.setEmail(updatedPS.getPortalUser().getEmail());
        portalUserSafeVO.setUserLast(updatedPS.getPortalUser().getUserLast());
        updatedPS.setUserSafeVO(portalUserSafeVO);
        this.log.info("PS updated successfully: {}", (Object)updatedPS.getFirstName());
        return ResponseEntity.ok((Object)updatedPS);
    }

    @DeleteMapping(value={"/deletePortalUser/{id}"})
    public ResponseEntity<PortalUser> deletePortalUser(@PathVariable Long id) {
        if (id == null) {
            this.log.warn("Delete portal user request with null ID");
            throw new ValidationException("User ID is required");
        }
        this.log.info("Disabling portal user with ID: {}", (Object)id);
        PortalUser disabledUser = this.portalUserService.disablePortalUser(id);
        this.log.info("Portal user disabled successfully: {} (ID: {})", (Object)disabledUser.getUsername(), (Object)id);
        return ResponseEntity.ok((Object)disabledUser);
    }

    @PostMapping(value={"/assignAuthorities/{id}"})
    public ResponseEntity<PortalUser> assignAuthorities(@PathVariable Long id, @RequestBody UpdateAuthoritiesRequest req) {
        if (req == null || req.authorities == null || req.authorities.isEmpty()) {
            throw new ValidationException("Authorities list is required");
        }
        PortalUser updated = this.portalUserService.assignAuthorities(id, req.authorities);
        return ResponseEntity.ok((Object)updated);
    }

    @PutMapping(value={"/replaceAuthorities/{id}"})
    public ResponseEntity<PortalUser> replaceAuthorities(@PathVariable Long id, @RequestBody UpdateAuthoritiesRequest req) {
        if (req == null || req.authorities == null) {
            throw new ValidationException("Authorities list is required");
        }
        PortalUser updated = this.portalUserService.replaceAuthorities(id, req.authorities);
        return ResponseEntity.ok((Object)updated);
    }

    @GetMapping(value={"/districts"})
    public ResponseEntity<List<DistrictSafeVO>> getDistricts() {
        this.log.info("Fetching all districts");
        ArrayList safeList = new ArrayList();
        this.districtRepository.findAll().forEach(d -> {
            DistrictSafeVO vo = new DistrictSafeVO(d.getId(), d.getDistrictName());
            if (d.getStore() != null) {
                vo.setStoreId(d.getStore().getId());
                vo.setStoreName(d.getStore().getName());
                vo.setStoreNum(d.getStore().getStoreNum());
                vo.setStoreCity(d.getStore().getCity());
                vo.setStoreState(d.getStore().getState());
            }
            safeList.add(vo);
        });
        this.log.debug("Retrieved {} districts (safe VO)", (Object)safeList.size());
        return ResponseEntity.ok(safeList);
    }

    private void validatePortalUser(PortalUser portalUser) {
        if (portalUser == null) {
            throw new ValidationException("Portal user data is required");
        }
        if (portalUser.getUsername() == null || portalUser.getUsername().trim().isEmpty()) {
            throw new ValidationException("Username is required");
        }
        if (!StringUtils.hasText((String)portalUser.getEmail())) {
            throw new ValidationException("Email is required");
        }
    }

    private void validatePortalUserForUpdate(PortalUser portalUser) {
        if (portalUser == null) {
            throw new ValidationException("Portal user data is required");
        }
        if (portalUser.getId() == null) {
            throw new ValidationException("User ID is required for updates");
        }
        if (portalUser.getEmail() != null && !StringUtils.hasText((String)portalUser.getEmail())) {
            throw new ValidationException("Email cannot be blank when provided");
        }
    }
}

