/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.configurations;

import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ValidationExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<FormSubmissionResponse> handleValidationExceptions(MethodArgumentNotValidException ex, HttpServletRequest request) {
        log.warn("Validation error occurred: {} field errors", (Object)ex.getBindingResult().getFieldErrorCount());
        HashMap fieldErrors = new HashMap();
        ex.getBindingResult().getFieldErrors().forEach(error -> {
            String fieldName = error.getField();
            String errorMessage = error.getDefaultMessage();
            fieldErrors.put(fieldName, errorMessage);
            log.debug("Field '{}': {}", (Object)fieldName, (Object)errorMessage);
        });
        String errorMessage = fieldErrors.values().stream().collect(Collectors.joining(", "));
        ApiError apiError = new ApiError("validation", errorMessage);
        apiError.setStatus(HttpStatus.BAD_REQUEST);
        Object cid = request.getAttribute("CORRELATION_ID");
        if (cid != null) {
            apiError.setCorrelationId(cid.toString());
        }
        FormSubmissionResponse response = new FormSubmissionResponse();
        response.setSuccess(false);
        response.setApiError(apiError);
        response.setFormName("Form Validation");
        return ResponseEntity.badRequest().body((Object)response);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<FormSubmissionResponse> handleIllegalArgumentException(IllegalArgumentException ex, HttpServletRequest request) {
        log.warn("Illegal argument: {}", (Object)ex.getMessage());
        ApiError apiError = new ApiError("validation", ex.getMessage());
        apiError.setStatus(HttpStatus.BAD_REQUEST);
        Object cid = request.getAttribute("CORRELATION_ID");
        if (cid != null) {
            apiError.setCorrelationId(cid.toString());
        }
        FormSubmissionResponse response = new FormSubmissionResponse();
        response.setSuccess(false);
        response.setApiError(apiError);
        return ResponseEntity.badRequest().body((Object)response);
    }
}

