ALTER TABLE portal_user_roles
    DROP CONSTRAINT fk_poruserol_on_portal_user;

ALTER TABLE portal_user_roles
    DROP CONSTRAINT fk_poruserol_on_user_role;

CREATE TABLE employee_work_tickets
(
    employee_id     BIGINT NOT NULL,
    work_tickets_id BIGINT NOT NULL
);

CREATE TABLE portal_user_target_order
(
    portal_user_id  BIGINT NOT NULL,
    target_order_id BIGINT NOT NULL
);

CREATE TABLE portal_user_work_tickets
(
    portal_user_id  BIGINT NOT NULL,
    work_tickets_id BIGINT NOT NULL
);

CREATE TABLE store_target_order_list
(
    store_id             BIGINT NOT NULL,
    target_order_list_id BIGINT NOT NULL
);

CREATE TABLE store_work_tickets
(
    store_id        BIGINT NOT NULL,
    work_tickets_id BIGINT NOT NULL
);

ALTER TABLE new_hire
    ADD a_number VARCHAR(255);

ALTER TABLE new_hire
    ADD document_exp date;

ALTER TABLE new_hire
    ADD document_number VARCHAR(255);

ALTER TABLE new_hire
    ADD document_title VARCHAR(255);

ALTER TABLE store
    ADD new_hire_id BIGINT;

ALTER TABLE employee_work_tickets
    ADD CONSTRAINT uc_employee_work_tickets_worktickets UNIQUE (work_tickets_id);

ALTER TABLE portal_user_target_order
    ADD CONSTRAINT uc_portal_user_target_order_targetorder UNIQUE (target_order_id);

ALTER TABLE portal_user_work_tickets
    ADD CONSTRAINT uc_portal_user_work_tickets_worktickets UNIQUE (work_tickets_id);

ALTER TABLE portal_user
    ADD CONSTRAINT uc_portaluser_user_name UNIQUE (user_name);

ALTER TABLE store_target_order_list
    ADD CONSTRAINT uc_store_target_order_list_targetorderlist UNIQUE (target_order_list_id);

ALTER TABLE store_work_tickets
    ADD CONSTRAINT uc_store_work_tickets_worktickets UNIQUE (work_tickets_id);

ALTER TABLE store
    ADD CONSTRAINT FK_STORE_ON_NEW_HIRE FOREIGN KEY (new_hire_id) REFERENCES new_hire (id);

ALTER TABLE employee_work_tickets
    ADD CONSTRAINT fk_empwortic_on_employee FOREIGN KEY (employee_id) REFERENCES employee (id);

ALTER TABLE employee_work_tickets
    ADD CONSTRAINT fk_empwortic_on_work_ticket FOREIGN KEY (work_tickets_id) REFERENCES work_ticket (id);

ALTER TABLE portal_user_target_order
    ADD CONSTRAINT fk_porusetarord_on_portal_user FOREIGN KEY (portal_user_id) REFERENCES portal_user (id);

ALTER TABLE portal_user_target_order
    ADD CONSTRAINT fk_porusetarord_on_target_order FOREIGN KEY (target_order_id) REFERENCES target_order (id);

ALTER TABLE portal_user_work_tickets
    ADD CONSTRAINT fk_porusewortic_on_portal_user FOREIGN KEY (portal_user_id) REFERENCES portal_user (id);

ALTER TABLE portal_user_work_tickets
    ADD CONSTRAINT fk_porusewortic_on_work_ticket FOREIGN KEY (work_tickets_id) REFERENCES work_ticket (id);

ALTER TABLE store_target_order_list
    ADD CONSTRAINT fk_stotarordlis_on_store FOREIGN KEY (store_id) REFERENCES store (id);

ALTER TABLE store_target_order_list
    ADD CONSTRAINT fk_stotarordlis_on_target_order FOREIGN KEY (target_order_list_id) REFERENCES target_order (id);

ALTER TABLE store_work_tickets
    ADD CONSTRAINT fk_stowortic_on_store FOREIGN KEY (store_id) REFERENCES store (id);

ALTER TABLE store_work_tickets
    ADD CONSTRAINT fk_stowortic_on_work_ticket FOREIGN KEY (work_tickets_id) REFERENCES work_ticket (id);

DROP TABLE portal_user_roles CASCADE;

ALTER TABLE target_order_item
    DROP COLUMN item_type;