ALTER TABLE target_order
    DROP CONSTRAINT fk_targetorder_on_employee;

CREATE SEQUENCE IF NOT EXISTS target_item_seq START WITH 1 INCREMENT BY 1;

CREATE SEQUENCE IF NOT EXISTS target_order_item_seq START WITH 1 INCREMENT BY 1;


CREATE TABLE target_item
(
    id        BIGINT NOT NULL,
    item_name VARCHAR(255),
    item_type VARCHAR(255),
    CONSTRAINT pk_targetitem PRIMARY KEY (id)
);

CREATE TABLE target_order_item
(
    id        BIGINT NOT NULL,
    name      VARCHAR(255),
    quantity  INTEGER,
    item_type VARCHAR(255),
    CONSTRAINT pk_targetorderitem PRIMARY KEY (id)
);

CREATE TABLE target_order_target_order_items
(
    target_order_id       BIGINT NOT NULL,
    target_order_items_id BIGINT NOT NULL
);

ALTER TABLE target_order_target_order_items
    ADD CONSTRAINT uc_target_order_target_order_items_targetorderitems UNIQUE (target_order_items_id);

ALTER TABLE target_order_target_order_items
    ADD CONSTRAINT fk_tarordtarordite_on_target_order FOREIGN KEY (target_order_id) REFERENCES target_order (id);

ALTER TABLE target_order_target_order_items
    ADD CONSTRAINT fk_tarordtarordite_on_target_order_item FOREIGN KEY (target_order_items_id) REFERENCES target_order_item (id);

ALTER TABLE target_order
    DROP COLUMN employee_id;

ALTER SEQUENCE back_pay_date_seq INCREMENT BY 1;

ALTER SEQUENCE back_pay_seq INCREMENT BY 1;

ALTER SEQUENCE bonus_date_seq INCREMENT BY 1;

ALTER SEQUENCE bonus_seq INCREMENT BY 1;

ALTER SEQUENCE hotel_seq INCREMENT BY 1;

ALTER SEQUENCE mileage_date_seq INCREMENT BY 1;

ALTER SEQUENCE mileage_seq INCREMENT BY 1;

ALTER SEQUENCE new_hire_seq INCREMENT BY 1;

ALTER SEQUENCE per_diem_seq INCREMENT BY 1;

ALTER SEQUENCE portal_user_seq INCREMENT BY 1;

ALTER SEQUENCE pto_seq INCREMENT BY 1;

ALTER SEQUENCE store_seq INCREMENT BY 1;

ALTER SEQUENCE target_order_seq INCREMENT BY 1;

ALTER SEQUENCE termination_seq INCREMENT BY 1;

ALTER SEQUENCE time_adjust_break_seq INCREMENT BY 1;

ALTER SEQUENCE time_adjustment_seq INCREMENT BY 1;

ALTER SEQUENCE uniform_seq INCREMENT BY 1;

ALTER SEQUENCE user_role_seq INCREMENT BY 1;

ALTER SEQUENCE work_ticket_seq INCREMENT BY 1;