CREATE SEQUENCE IF NOT EXISTS non_mn_mileage_seq START WITH 1 INCREMENT BY 1;

CREATE TABLE non_mn_mileage
(
    id             BIGINT NOT NULL,
    comments       VARCHAR(255),
    employee_id    BIGINT,
    portal_user_id BIGINT,
    CONSTRAINT pk_nonmnmileage PRIMARY KEY (id)
);

CREATE TABLE non_mn_mileage_mileage_dates
(
    non_mn_mileage_id BIGINT NOT NULL,
    mileage_dates_id  BIGINT NOT NULL
);

ALTER TABLE non_mn_mileage_mileage_dates
    ADD CONSTRAINT uc_non_mn_mileage_mileage_dates_mileagedates UNIQUE (mileage_dates_id);

ALTER TABLE non_mn_mileage
    ADD CONSTRAINT FK_NONMNMILEAGE_ON_EMPLOYEE FOREIGN KEY (employee_id) REFERENCES employee (id);

ALTER TABLE non_mn_mileage
    ADD CONSTRAINT FK_NONMNMILEAGE_ON_PORTAL_USER FOREIGN KEY (portal_user_id) REFERENCES portal_user (id);

ALTER TABLE non_mn_mileage_mileage_dates
    ADD CONSTRAINT fk_nonmnmilmildat_on_mileage_date FOREIGN KEY (mileage_dates_id) REFERENCES mileage_date (id);

ALTER TABLE non_mn_mileage_mileage_dates
    ADD CONSTRAINT fk_nonmnmilmildat_on_non_mn_mileage FOREIGN KEY (non_mn_mileage_id) REFERENCES non_mn_mileage (id);
