/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.Address;
import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.NewHire;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.NewHireRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.NewHireService;
import com.cbmportal.portal.services.PdfBuilderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NewHireServiceImpl
implements NewHireService {
    private final Logger log = LoggerFactory.getLogger(NewHireServiceImpl.class);
    private final NewHireRepository newHireRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public NewHireServiceImpl(NewHireRepository newHireRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.newHireRepository = newHireRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processNewHire(NewHire newHire, MultipartFile idBadge, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File newHireHtml = new File(this.htmlFormLocation + "newhire.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String pdfFileName = "newHire-" + newHire.getEmployee().getEmployeeFirst() + "-" + newHire.getEmployee().getEmployeeLast() + "--" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "newHire/" + newHire.getEmployee().getEmployeeFirst() + "-" + newHire.getEmployee().getEmployeeLast() + "/";
        File empImageD = new File(pdfSaveLocation + "image/" + Objects.requireNonNull(idBadge.getOriginalFilename()).replace(" ", "-") + ".png");
        File idBadgeFile = new File(pdfSaveLocation + "image/" + Objects.requireNonNull(idBadge.getOriginalFilename()).replace(" ", "-") + ".png");
        if (!empImageD.exists() && empImageD.mkdirs()) {
            this.log.info("Employee image saved successfully");
        }
        if (empImageD.exists()) {
            idBadge.transferTo(idBadgeFile);
        }
        Document doc = Jsoup.parse((File)newHireHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("address").html(this.formatAddress(newHire.getEmployee().getAddress()));
        doc.getElementsByClass("phone1").html(newHire.getEmployee().getPhone1());
        doc.getElementsByClass("phone2").html(newHire.getEmployee().getPhone2());
        doc.getElementsByClass("employeeFirstName").html(newHire.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeMiddleName").html(newHire.getEmployee().getEmployeeMiddle());
        doc.getElementsByClass("employeeLastName").html(newHire.getEmployee().getEmployeeLast());
        doc.getElementsByClass("employeeSecondLastName").html(newHire.getEmployee().getEmployeeSecondLast());
        doc.getElementsByClass("email").html(newHire.getEmployee().getEmail());
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("dob").html(dateFormatter.format(newHire.getEmployee().getDob()));
        doc.getElementsByClass("ssn").html(newHire.getEmployee().getSsn());
        doc.getElementsByClass("gender").html(newHire.getEmployee().getGender().getGender());
        doc.getElementsByClass("numWorkDays").html(newHire.getNumWorkDays().toString());
        doc.getElementsByClass("store").html(newHire.getStore().getStoreNum() + " " + newHire.getStore().getName());
        doc.getElementsByClass("payRate").html(newHire.getPayRate().toString());
        doc.getElementsByClass("position").html(newHire.getPosition().getPosition() + " " + newHire.getPositionNum());
        doc.getElementsByClass("numOfHours").html(newHire.getNumOfHours());
        doc.getElementsByClass("preferredLanguage").html(newHire.getPreferredLanguage());
        doc.getElementsByClass("firstDayWorked").html(dateFormatter.format(newHire.getFirstDayWorked()));
        doc.getElementsByClass("hireType").html(newHire.getHireType());
        doc.getElementsByClass("comments").html(newHire.getComments());
        doc.getElementsByClass("idBadgeLocation").html("<a href=" + idBadgeFile + ">" + idBadge.getOriginalFilename() + "</a>");
        doc.getElementsByClass("dm").html(newHire.getPortalUser().getUserFirst() + " " + newHire.getPortalUser().getUserLast());
        doc.getElementsByClass("documentTitle").html(newHire.getDocumentTitle());
        doc.getElementsByClass("documentNumber").html(newHire.getDocumentNumber());
        doc.getElementsByClass("aNum").html(newHire.getANumber());
        doc.getElementsByClass("documentExp").html(dateFormatter.format(newHire.getDocumentExp()));
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessageNewHire(DepartmentEmails.NewHires.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, idBadgeFile, newHire.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                NewHire savedNewHire = (NewHire)this.newHireRepository.save(newHire);
                if (savedNewHire.getId() != null) {
                    formResponse.setFormName("NewHire Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/hr/newHireSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("NewHire Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }

    String formatAddress(Address address) {
        if (address.getAddress2().isEmpty()) {
            return address.getAddress1() + "\n" + address.getCity() + "\n" + address.getState() + "\n" + address.getZip();
        }
        return address.getAddress1() + "\n#" + address.getAddress2() + "\n" + address.getCity() + "\n" + address.getState() + "\n" + address.getZip();
    }

    @Override
    public NewHire processNewHire(NewHire newhire, MultipartFile idBadge) throws IOException {
        return null;
    }
}

