/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.services.EmailService;
import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements EmailService {
    final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    private final JavaMailSenderImpl emailSender;

    public EmailServiceImpl(JavaMailSenderImpl emailSender) {
        this.emailSender = emailSender;
    }

    @Override
    public void sendMessageNewHire(String to, String subject, String pdf, File idBadge, String portalUserEmail) {
        MimeMessage message = this.emailSender.createMimeMessage();
        File pdfFile = new File(pdf);
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom("CBM IT <cbmmailer@carlsonbuilding.com>");
            helper.setTo(to);
            helper.setCc(portalUserEmail);
            helper.setSubject(subject);
            helper.setText(pdfFile.getName() + " file attached.");
            FileSystemResource resource = new FileSystemResource(pdfFile);
            helper.addAttachment(pdfFile.getName(), (InputStreamSource)resource);
            helper.addAttachment(idBadge.getName(), idBadge);
            this.emailSender.send(message);
        }
        catch (MessagingException mExc) {
            this.log.error(mExc.getMessage());
        }
    }

    @Override
    public void sendMessage(String to, String subject, String pdf, String portalUserEmail) {
        MimeMessage message = this.emailSender.createMimeMessage();
        File pdfFile = new File(pdf);
        String[] ccEmails = new String[]{portalUserEmail, "joseph.schaeppi@carlsonbuilding.com"};
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom("CBM IT <cbmmailer@carlsonbuilding.com>");
            helper.setTo(to);
            helper.setCc(ccEmails);
            helper.setSubject(subject);
            helper.setText(pdfFile.getName() + " file attached.");
            FileSystemResource resource = new FileSystemResource(pdfFile);
            helper.addAttachment(pdfFile.getName(), (InputStreamSource)resource);
            this.emailSender.send(message);
        }
        catch (MessagingException mExc) {
            this.log.error(mExc.getMessage());
        }
    }
}

