/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.BackPayDate;
import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.BackpayRepository;
import com.cbmportal.portal.services.BackPayService;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class BackPayServiceImpl
implements BackPayService {
    final Logger log = LoggerFactory.getLogger(BackPayServiceImpl.class);
    private final BackpayRepository backpayRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private String pdfFilePath = "";

    public BackPayServiceImpl(BackpayRepository backpayRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.backpayRepository = backpayRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processBackPay(BackPay backPay, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        List<BackPayDate> backPayDates = backPay.getBackPayDates();
        File bpHtml = new File(this.htmlFormLocation + "backpay.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("hh:mm a");
        StringBuilder backPayDateInfo = new StringBuilder();
        String fullEmployeeNane = backPay.getEmployee().getEmployeeFirst() + " " + backPay.getEmployee().getEmployeeLast();
        String pdfFileName = "Backpay-" + fullEmployeeNane + "-" + backPay.getEmployee().getEmployeeNumber() + "-" + dateFormatter.format(LocalDate.now()) + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "backpay/" + backPay.getEmployee().getEmployeeNumber() + "/";
        for (BackPayDate backPayDate : backPayDates) {
            double shiftHours = BackPayServiceImpl.getShiftHours(backPayDate);
            double breakHours = this.getBreakHours(backPayDate);
            BigDecimal netHours = BigDecimal.valueOf(shiftHours - breakHours);
            this.backPayInfoInject(netHours, backPayDate, backPayDateInfo, dateFormatter, timeFormatter);
        }
        Document doc = Jsoup.parse((File)bpHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("backPayInfo").html(backPayDateInfo.toString());
        doc.getElementsByClass("todayDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("employeeNum").html(backPay.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeName").html(fullEmployeeNane);
        doc.getElementsByClass("storeName").html(backPay.getStore().getStoreNum() + " " + backPay.getStore().getName());
        doc.getElementsByClass("dmName").html(backPay.getPortalUser().getUserFirst() + " " + backPay.getPortalUser().getUserLast());
        doc.getElementsByClass("dmSig").html("<img src=" + backPay.getSig() + " alt=\" This is signature\" />");
        doc.getElementsByClass("reasonMissed").html(backPay.getPayMissed());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Payroll.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, backPay.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                BackPay savedBackpay = (BackPay)this.backpayRepository.save(backPay);
                if (savedBackpay.getId() != null) {
                    formResponse.setFormName("BackPay Form");
                    formResponse.setSuccess(true);
                }
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/payroll/submitBackPay");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("BackPay Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        return formResponse;
    }

    private static double getShiftHours(BackPayDate backPayDate) {
        double calculatedShiftHrs = 0.0;
        calculatedShiftHrs = backPayDate.getPunchIn().until(backPayDate.getPunchOut(), ChronoUnit.HOURS);
        return calculatedShiftHrs;
    }

    private double getBreakHours(BackPayDate backPayDate) {
        double calculatedBreakHrs = 0.0;
        if (backPayDate.getLeft_lunch() != null && backPayDate.getReturn_lunch() != null) {
            calculatedBreakHrs = (double)LocalDateTime.parse(backPayDate.getLeft_lunch()).until(LocalDateTime.parse(backPayDate.getReturn_lunch()), ChronoUnit.MINUTES) / 60.0;
        }
        return calculatedBreakHrs;
    }

    private void backPayInfoInject(BigDecimal netHours, BackPayDate backPayDate, StringBuilder backPayDateInfo, DateTimeFormatter dateFormatter, DateTimeFormatter timeFormatter) {
        if (backPayDate.getLeft_lunch() == null && backPayDate.getReturn_lunch() == null) {
            backPayDateInfo.append("<div class=backPayInfoContainer>");
            backPayDateInfo.append("<div style=\"width: 13%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(dateFormatter.format(backPayDate.getDate())).append("</div>");
            backPayDateInfo.append("<div style=\"width: 15%; border-bottom: 1px solid black;  padding: 1px; text-align: left;\">").append(timeFormatter.format(backPayDate.getPunchIn())).append("</div>");
            backPayDateInfo.append("<div style=\"width: 22%; border-bottom: 1px solid black; padding: 1px; text-align: left;\"> No Time </div>");
            backPayDateInfo.append("<div style=\"width: 21%; border-bottom: 1px solid black; padding: 1px; text-align: left;\"> No Time </div>");
            backPayDateInfo.append("<div style=\"width: 13%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(timeFormatter.format(backPayDate.getPunchOut())).append("</div>");
            backPayDateInfo.append("<div style=\"width: 12%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(netHours.setScale(2, RoundingMode.UP)).append(" hrs</div>");
            backPayDateInfo.append("</div>");
        } else {
            backPayDateInfo.append("<div class=backPayInfoContainer>");
            backPayDateInfo.append("<div style=\"width: 13%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(dateFormatter.format(backPayDate.getDate())).append("</div>");
            backPayDateInfo.append("<div style=\"width: 15%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(timeFormatter.format(backPayDate.getPunchIn())).append("</div>");
            backPayDateInfo.append("<div style=\"width: 21%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(timeFormatter.format(LocalDateTime.parse(backPayDate.getLeft_lunch()))).append("</div>");
            backPayDateInfo.append("<div style=\"width: 22%; border-bottom: 1px solid black;  padding: 1px; text-align: left;\">").append(timeFormatter.format(LocalDateTime.parse(backPayDate.getReturn_lunch()))).append("</div>");
            backPayDateInfo.append("<div style=\"width: 13%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(timeFormatter.format(backPayDate.getPunchOut())).append("</div>");
            backPayDateInfo.append("<div style=\"width: 12%; border-bottom: 1px solid black; padding: 1px; text-align: left;\">").append(netHours.setScale(2, RoundingMode.UP)).append(" hrs</div>");
            backPayDateInfo.append("</div>");
        }
    }
}

