/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.UserPermission;
import com.cbmportal.portal.domains.UserRole;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.AuthUser;
import com.cbmportal.portal.domains.VO.LoginResponseVO;
import com.cbmportal.portal.repositories.PortalUserRepository;
import com.cbmportal.portal.repositories.UserRoleRepository;
import com.cbmportal.portal.services.AuthenticationService;
import com.cbmportal.portal.services.TokenService;
import com.nimbusds.jose.JOSEException;
import jakarta.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthenticationServiceImpl
implements AuthenticationService {
    Logger log = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private final PortalUserRepository portalUserRepository;
    private final UserRoleRepository userRoleRepository;
    private final PasswordEncoder passwordEncoder;
    private final AuthenticationManager authenticationManager;
    private final TokenService tokenService;

    public AuthenticationServiceImpl(PortalUserRepository portalUserRepository, UserRoleRepository userRoleRepository, PasswordEncoder passwordEncoder, AuthenticationManager authenticationManager, TokenService tokenService) {
        this.portalUserRepository = portalUserRepository;
        this.userRoleRepository = userRoleRepository;
        this.passwordEncoder = passwordEncoder;
        this.authenticationManager = authenticationManager;
        this.tokenService = tokenService;
    }

    @Override
    public PortalUser registerUser(PortalUser portalUser) {
        String encodedPassword = this.passwordEncoder.encode((CharSequence)portalUser.getPassword());
        UserRole userRole = this.userRoleRepository.findByAuthority(UserPermission.DM.name()).get();
        HashSet<UserRole> authorities = new HashSet<UserRole>();
        authorities.add(userRole);
        portalUser.setPassword(encodedPassword);
        portalUser.setAuthorities(authorities);
        return (PortalUser)this.portalUserRepository.save(portalUser);
    }

    @Override
    public LoginResponseVO loginUser(String username, String password, HttpServletResponse response) {
        username = username.toLowerCase();
        try {
            Authentication auth = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
            String token = this.tokenService.generateJwt(auth);
            LoginResponseVO responseVO = new LoginResponseVO();
            AuthUser recoveredUser = new AuthUser();
            PortalUser portalUser = this.portalUserRepository.findPortalUserByUserName(username).orElseThrow();
            this.setRecoveredUsersValues(recoveredUser, portalUser);
            responseVO.setUser(recoveredUser);
            responseVO.setJwt(token);
            responseVO.setJwtStatus(true);
            return responseVO;
        }
        catch (JOSEException | ParseException | AuthenticationException authExc) {
            this.log.info("In catch " + authExc.getMessage());
            response.setStatus(500);
            return new LoginResponseVO(null, false, new ApiError("loginUser", authExc.getMessage()));
        }
    }

    private void setRecoveredUsersValues(AuthUser recoveredUser, PortalUser portalUser) {
        recoveredUser.setId(portalUser.getId());
        recoveredUser.setAuthorities((Set<UserRole>)portalUser.getAuthorities());
        recoveredUser.setDistrict(portalUser.getDistrict());
        recoveredUser.setUserFirst(portalUser.getUserFirst());
        recoveredUser.setUserLast(portalUser.getUserLast());
        recoveredUser.setEmail(portalUser.getEmail());
        recoveredUser.setUserName(portalUser.getUsername());
        recoveredUser.setPermission(portalUser.getPermission());
    }

    @Override
    public LoginResponseVO validateJwt(String token) {
        try {
            DecodedJWT jwtDecoder = JWT.decode((String)token);
            if (jwtDecoder.getExpiresAtAsInstant().isAfter(Instant.now())) {
                LoginResponseVO authResponse = new LoginResponseVO();
                PortalUser portalUser = this.portalUserRepository.findPortalUserByUserName(jwtDecoder.getSubject()).orElse(new PortalUser());
                AuthUser recoveredUser = new AuthUser();
                this.setRecoveredUsersValues(recoveredUser, portalUser);
                authResponse.setJwt(token);
                authResponse.setJwtStatus(true);
                authResponse.setUser(recoveredUser);
                return authResponse;
            }
            return new LoginResponseVO(null, false, new ApiError("loginUser", "Bad credentials"));
        }
        catch (AuthenticationException authExc) {
            return new LoginResponseVO(null, false, new ApiError("loginUser", authExc.getMessage()));
        }
    }
}

