/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Size;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class Uniform {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="uniform_id_seq")
    @SequenceGenerator(name="uniform_id_seq", sequenceName="uniform_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    private Integer quantity;
    @JsonProperty
    private Double total;
    @JsonProperty
    private Size size;
    @JsonProperty
    private String sig;
    @JsonProperty
    @Transient
    private boolean success;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public Uniform() {
    }

    public Uniform(Employee employee, PortalUser portalUser, Integer quantity, Double total, Size size, String sig, ApiError apiError) {
        this.employee = employee;
        this.portalUser = portalUser;
        this.quantity = quantity;
        this.total = total;
        this.size = size;
        this.sig = sig;
        this.apiError = apiError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uniform uniform = (Uniform)o;
        return Objects.equals(this.id, uniform.id) && Objects.equals(this.employee, uniform.employee) && Objects.equals(this.portalUser, uniform.portalUser) && Objects.equals(this.quantity, uniform.quantity) && Objects.equals(this.total, uniform.total) && this.size == uniform.size && Objects.equals(this.sig, uniform.sig) && Objects.equals(this.apiError, uniform.apiError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.employee, this.portalUser, this.quantity, this.total, this.size, this.sig, this.apiError});
    }

    public String toString() {
        return new StringJoiner(", ", Uniform.class.getSimpleName() + "[", "]").add("id=" + this.id).add("employee=" + this.employee).add("portalUser=" + this.portalUser).add("quantity=" + this.quantity).add("total=" + this.total).add("size=" + this.size).add("sig='" + this.sig + "'").add("apiError=" + this.apiError).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @JsonProperty
    public void setTotal(Double total) {
        this.total = total;
    }

    @JsonProperty
    public void setSize(Size size) {
        this.size = size;
    }

    @JsonProperty
    public void setSig(String sig) {
        this.sig = sig;
    }

    @JsonProperty
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Double getTotal() {
        return this.total;
    }

    public Size getSize() {
        return this.size;
    }

    public String getSig() {
        return this.sig;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

