/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.TimeAdjustBreak;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class TimeAdjustment {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="timeAdjustment_id_seq")
    @SequenceGenerator(name="timeAdjustment_id_seq", sequenceName="time_adjustment_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    private String reasonMissed;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<TimeAdjustBreak> breaks;
    @JsonProperty
    private String managerSig;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    private String employeeSig;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public String toString() {
        return new StringJoiner(", ", TimeAdjustment.class.getSimpleName() + "[", "]").add("id=" + this.id).add("reasonMissed='" + this.reasonMissed + "'").add("breaks=" + this.breaks).add("managerSig='" + this.managerSig + "'").add("employee=" + this.employee).add("portalUser=" + this.portalUser).add("employeeSig='" + this.employeeSig + "'").add("apiError=" + this.apiError).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeAdjustment that = (TimeAdjustment)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.reasonMissed, that.reasonMissed) && Objects.equals(this.breaks, that.breaks) && Objects.equals(this.managerSig, that.managerSig) && Objects.equals(this.employee, that.employee) && Objects.equals(this.portalUser, that.portalUser) && Objects.equals(this.employeeSig, that.employeeSig) && Objects.equals(this.apiError, that.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.reasonMissed, this.breaks, this.managerSig, this.employee, this.portalUser, this.employeeSig, this.apiError);
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setReasonMissed(String reasonMissed) {
        this.reasonMissed = reasonMissed;
    }

    @JsonProperty
    public void setBreaks(List<TimeAdjustBreak> breaks) {
        this.breaks = breaks;
    }

    @JsonProperty
    public void setManagerSig(String managerSig) {
        this.managerSig = managerSig;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setEmployeeSig(String employeeSig) {
        this.employeeSig = employeeSig;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public String getReasonMissed() {
        return this.reasonMissed;
    }

    public List<TimeAdjustBreak> getBreaks() {
        return this.breaks;
    }

    public String getManagerSig() {
        return this.managerSig;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public String getEmployeeSig() {
        return this.employeeSig;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

