/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.TargetOrderItem;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class TargetOrder {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="targetOrder_id_seq")
    @SequenceGenerator(name="targetOrder_id_seq", sequenceName="target_order_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    private PortalUser portalUser;
    @JsonProperty
    @ManyToOne
    private Store store;
    @JsonProperty
    private String comments;
    @JsonProperty
    @OneToMany
    @Cascade(value={CascadeType.ALL})
    private List<TargetOrderItem> targetOrderItems;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetOrder that = (TargetOrder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.portalUser, that.portalUser) && Objects.equals(this.store, that.store) && Objects.equals(this.comments, that.comments) && Objects.equals(this.targetOrderItems, that.targetOrderItems) && Objects.equals(this.apiError, that.apiError);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.portalUser, this.store, this.comments, this.targetOrderItems, this.apiError);
    }

    public String toString() {
        return new StringJoiner(", ", TargetOrder.class.getSimpleName() + "[", "]").add("id=" + this.id).add("portalUser=" + this.portalUser).add("store=" + this.store).add("comments='" + this.comments + "'").add("targetOrderItems=" + this.targetOrderItems).add("apiError=" + this.apiError).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    public void setTargetOrderItems(List<TargetOrderItem> targetOrderItems) {
        this.targetOrderItems = targetOrderItems;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public Store getStore() {
        return this.store;
    }

    public String getComments() {
        return this.comments;
    }

    public List<TargetOrderItem> getTargetOrderItems() {
        return this.targetOrderItems;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

