/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.domains;

import com.cbmportal.portal.domains.Employee;
import com.cbmportal.portal.domains.PortalUser;
import com.cbmportal.portal.domains.Position;
import com.cbmportal.portal.domains.Store;
import com.cbmportal.portal.domains.VO.ApiError;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
public class NewHire {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="newHire_id_seq")
    @SequenceGenerator(name="newHire_id_seq", sequenceName="new_hire_seq", allocationSize=1)
    private Long id;
    @JsonProperty
    @OneToOne
    @Cascade(value={CascadeType.ALL})
    private Employee employee = null;
    @JsonProperty
    @OneToOne
    private PortalUser portalUser;
    @JsonProperty
    @OneToOne
    private Store store;
    @JsonProperty
    private String hireType;
    @JsonProperty
    private Integer numWorkDays;
    @JsonProperty
    private Double payRate;
    @JsonProperty
    private String numOfHours;
    @JsonProperty
    private String preferredLanguage;
    @JsonProperty
    private String comments;
    @JsonProperty
    private Position position;
    @JsonProperty
    @Transient
    private String positionNum = "";
    @JsonProperty
    private LocalDate firstDayWorked;
    @JsonProperty
    private String documentTitle;
    @JsonProperty
    private String documentNumber;
    @JsonProperty
    private String aNumber;
    @JsonProperty
    private LocalDate documentExp;
    @JsonProperty
    @Transient
    private ApiError apiError;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewHire newHire = (NewHire)o;
        return Objects.equals(this.id, newHire.id) && Objects.equals(this.employee, newHire.employee) && Objects.equals(this.portalUser, newHire.portalUser) && Objects.equals(this.store, newHire.store) && Objects.equals(this.hireType, newHire.hireType) && Objects.equals(this.numWorkDays, newHire.numWorkDays) && Objects.equals(this.payRate, newHire.payRate) && Objects.equals(this.numOfHours, newHire.numOfHours) && Objects.equals(this.preferredLanguage, newHire.preferredLanguage) && Objects.equals(this.comments, newHire.comments) && this.position == newHire.position && Objects.equals(this.positionNum, newHire.positionNum) && Objects.equals(this.firstDayWorked, newHire.firstDayWorked) && Objects.equals(this.documentTitle, newHire.documentTitle) && Objects.equals(this.documentNumber, newHire.documentNumber) && Objects.equals(this.aNumber, newHire.aNumber) && Objects.equals(this.documentExp, newHire.documentExp) && Objects.equals(this.apiError, newHire.apiError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.employee, this.portalUser, this.store, this.hireType, this.numWorkDays, this.payRate, this.numOfHours, this.preferredLanguage, this.comments, this.position, this.positionNum, this.firstDayWorked, this.documentTitle, this.documentNumber, this.aNumber, this.documentExp, this.apiError});
    }

    public String toString() {
        return new StringJoiner(", ", NewHire.class.getSimpleName() + "[", "]").add("id=" + this.id).add("employee=" + this.employee).add("portalUser=" + this.portalUser).add("store=" + this.store).add("hireType='" + this.hireType + "'").add("numWorkDays=" + this.numWorkDays).add("payRate=" + this.payRate).add("numOfHours='" + this.numOfHours + "'").add("preferredLanguage='" + this.preferredLanguage + "'").add("comments='" + this.comments + "'").add("position=" + this.position).add("positionNum='" + this.positionNum + "'").add("firstDayWorked=" + this.firstDayWorked).add("documentTitle='" + this.documentTitle + "'").add("documentNumber='" + this.documentNumber + "'").add("aNumber='" + this.aNumber + "'").add("documentExp=" + this.documentExp).add("apiError=" + this.apiError).toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty
    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @JsonProperty
    public void setPortalUser(PortalUser portalUser) {
        this.portalUser = portalUser;
    }

    @JsonProperty
    public void setStore(Store store) {
        this.store = store;
    }

    @JsonProperty
    public void setHireType(String hireType) {
        this.hireType = hireType;
    }

    @JsonProperty
    public void setNumWorkDays(Integer numWorkDays) {
        this.numWorkDays = numWorkDays;
    }

    @JsonProperty
    public void setPayRate(Double payRate) {
        this.payRate = payRate;
    }

    @JsonProperty
    public void setNumOfHours(String numOfHours) {
        this.numOfHours = numOfHours;
    }

    @JsonProperty
    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @JsonProperty
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty
    public void setPosition(Position position) {
        this.position = position;
    }

    @JsonProperty
    public void setPositionNum(String positionNum) {
        this.positionNum = positionNum;
    }

    @JsonProperty
    public void setFirstDayWorked(LocalDate firstDayWorked) {
        this.firstDayWorked = firstDayWorked;
    }

    @JsonProperty
    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    @JsonProperty
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @JsonProperty
    public void setANumber(String aNumber) {
        this.aNumber = aNumber;
    }

    @JsonProperty
    public void setDocumentExp(LocalDate documentExp) {
        this.documentExp = documentExp;
    }

    @JsonProperty
    public void setApiError(ApiError apiError) {
        this.apiError = apiError;
    }

    public Long getId() {
        return this.id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public PortalUser getPortalUser() {
        return this.portalUser;
    }

    public Store getStore() {
        return this.store;
    }

    public String getHireType() {
        return this.hireType;
    }

    public Integer getNumWorkDays() {
        return this.numWorkDays;
    }

    public Double getPayRate() {
        return this.payRate;
    }

    public String getNumOfHours() {
        return this.numOfHours;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getComments() {
        return this.comments;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getPositionNum() {
        return this.positionNum;
    }

    public LocalDate getFirstDayWorked() {
        return this.firstDayWorked;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public String getANumber() {
        return this.aNumber;
    }

    public LocalDate getDocumentExp() {
        return this.documentExp;
    }

    public ApiError getApiError() {
        return this.apiError;
    }
}

