/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.controllers;

import com.cbmportal.portal.domains.BackPay;
import com.cbmportal.portal.domains.Bonus;
import com.cbmportal.portal.domains.Mileage;
import com.cbmportal.portal.domains.Pto;
import com.cbmportal.portal.domains.TimeAdjustment;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.services.BackPayService;
import com.cbmportal.portal.services.BonusService;
import com.cbmportal.portal.services.MileageService;
import com.cbmportal.portal.services.PtoService;
import com.cbmportal.portal.services.TimeAdjustmentService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jsoup.helper.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/payroll"})
public class PayrollSubmissions {
    private final Logger log = LoggerFactory.getLogger(PayrollSubmissions.class);
    private final BackPayService backPayService;
    private final BonusService bonusService;
    private final MileageService mileageService;
    private final TimeAdjustmentService timeAdjustmentService;
    private final PtoService ptoService;

    public PayrollSubmissions(BackPayService backPayService, BonusService bonusService, MileageService mileageService, TimeAdjustmentService timeAdjustmentService, PtoService ptoService) {
        this.backPayService = backPayService;
        this.bonusService = bonusService;
        this.mileageService = mileageService;
        this.timeAdjustmentService = timeAdjustmentService;
        this.ptoService = ptoService;
    }

    @PostMapping(value={"/backPaySubmit"})
    public ResponseEntity<FormSubmissionResponse> submitBackPay(@RequestBody @NotNull BackPay backPay, HttpServletResponse response) throws IOException {
        this.log.info(backPay.toString());
        if (!backPay.getBackPayDates().isEmpty() && backPay.getEmployee() != null && backPay.getPortalUser() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.backPayService.processBackPay(backPay, response));
            }
            catch (IOException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitBackPay", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("BackPay Form", false, new ApiError("submitBackPay", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"/bonusSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitBonus(@RequestBody @NotNull Bonus bonus, HttpServletResponse response) throws IOException {
        this.log.info(bonus.toString());
        if (!bonus.getBonuses().isEmpty() && bonus.getEmployee() != null && bonus.getPortalUser() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.bonusService.processBonus(bonus, response));
            }
            catch (IOException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitBonus", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Bonus Form", false, new ApiError("submitBonus", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"/mileageSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitMileage(@RequestBody @NotNull Mileage mileage, HttpServletResponse response) throws IOException {
        this.log.info(mileage.toString());
        if (!mileage.getMileageDates().isEmpty() && mileage.getEmployee() != null && mileage.getPortalUser() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.mileageService.processMileage(mileage, response));
            }
            catch (IOException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitMileage", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Mileage Form", false, new ApiError("submitMileage", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"/ptoSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitPto(@RequestBody @NotNull Pto pto, HttpServletResponse response) throws IOException {
        this.log.info(pto.toString());
        if (pto.getHours() != null && pto.getHours() > 0.0 && pto.getAbsenceFrom() != null && pto.getAbsenceTo() != null && pto.getEmployee() != null && pto.getDepartment() != null && !Objects.equals(pto.getDepartment().getDepartment(), "") && pto.getSig() != null && pto.getPortalUser() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.ptoService.processPto(pto, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Pto Form", false, new ApiError("submitPto", "Please fill in every field that has an * next to it.")));
    }

    @PostMapping(value={"/timeAdjustmentSubmit"})
    public ResponseEntity<FormSubmissionResponse> submitPto(@RequestBody @NotNull TimeAdjustment timeAdjustment, HttpServletResponse response) throws IOException {
        this.log.info(timeAdjustment.toString());
        if (!timeAdjustment.getBreaks().isEmpty() && timeAdjustment.getEmployee() != null && timeAdjustment.getPortalUser() != null && timeAdjustment.getEmployeeSig() != null && timeAdjustment.getManagerSig() != null) {
            try {
                return ResponseEntity.status((int)response.getStatus()).body((Object)this.timeAdjustmentService.processTimeAdjustment(timeAdjustment, response));
            }
            catch (IOException | NullPointerException | ValidationException exc) {
                this.log.info(Arrays.toString(exc.getStackTrace()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new FormSubmissionResponse(new ApiError("submitPerDiem", exc.getMessage())));
            }
        }
        return ResponseEntity.status((int)400).body((Object)new FormSubmissionResponse("Time Adjustment Form", false, new ApiError("submitTimeAdjust", "Please fill in every field that has an * next to it.")));
    }
}

