/*
 * Decompiled with CFR 0.152.
 */
package com.cbmportal.portal.services.impl;

import com.cbmportal.portal.domains.DepartmentEmails;
import com.cbmportal.portal.domains.Uniform;
import com.cbmportal.portal.domains.VO.ApiError;
import com.cbmportal.portal.domains.VO.FormSubmissionResponse;
import com.cbmportal.portal.repositories.UniformRepository;
import com.cbmportal.portal.services.EmailService;
import com.cbmportal.portal.services.PdfBuilderService;
import com.cbmportal.portal.services.UniformService;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class UniformServiceImpl
implements UniformService {
    final Logger log = LoggerFactory.getLogger(UniformServiceImpl.class);
    private final UniformRepository uniformRepository;
    private final EmailService emailService;
    private final PdfBuilderService pdfBuilderService;
    private final String htmlFormLocation;
    private final String pdfFilePath;

    public UniformServiceImpl(UniformRepository uniformRepository, EmailService emailService, PdfBuilderService pdfBuilderService, @Value(value="${cbm.htmlFormLocation}") String htmlFormLocation, @Value(value="${cbm.pdfFiles}") String pdfFilePath) {
        this.uniformRepository = uniformRepository;
        this.emailService = emailService;
        this.pdfBuilderService = pdfBuilderService;
        this.htmlFormLocation = htmlFormLocation;
        this.pdfFilePath = pdfFilePath;
    }

    @Override
    public FormSubmissionResponse processUniform(Uniform uniform, HttpServletResponse response) throws IOException {
        FormSubmissionResponse formResponse = new FormSubmissionResponse();
        ApiError error = new ApiError();
        File uniformHtml = new File(this.htmlFormLocation + "uniform.html");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM-dd-uuu");
        String fullEmployeeName = uniform.getEmployee().getEmployeeFirst() + " " + uniform.getEmployee().getEmployeeLast();
        String pdfFileName = "uniform-" + fullEmployeeName + "-" + uniform.getEmployee().getEmployeeNumber() + LocalDate.now() + ".pdf";
        String pdfSaveLocation = this.pdfFilePath + "uniform/" + uniform.getEmployee().getEmployeeNumber() + "/";
        Document doc = Jsoup.parse((File)uniformHtml, (String)"UTF-8", (String)"");
        doc.getElementsByClass("address1").html(uniform.getEmployee().getAddress().getAddress1());
        doc.getElementsByClass("address2").html(uniform.getEmployee().getAddress().getAddress2());
        doc.getElementsByClass("city").html(uniform.getEmployee().getAddress().getCity());
        doc.getElementsByClass("state").html(uniform.getEmployee().getAddress().getState());
        doc.getElementsByClass("zip").html(uniform.getEmployee().getAddress().getZip());
        doc.getElementsByClass("employeeNum").html(uniform.getEmployee().getEmployeeNumber().toString());
        doc.getElementsByClass("employeeFirstName").html(uniform.getEmployee().getEmployeeFirst());
        doc.getElementsByClass("employeeLastName").html(uniform.getEmployee().getEmployeeLast());
        doc.getElementsByClass("currentDate").html(dateFormatter.format(LocalDate.now()));
        doc.getElementsByClass("total").html("$" + uniform.getTotal().toString());
        doc.getElementsByClass("quantity").html(uniform.getQuantity().toString());
        doc.getElementsByClass("size").html(uniform.getSize().getSize());
        doc.getElementsByClass("EEsignature").html("<img src=" + uniform.getSig() + " alt=\" This is signature\" />");
        doc.getElementsByClass("dm").html(uniform.getPortalUser().getUserFirst() + " " + uniform.getPortalUser().getUserLast());
        try {
            File d = new File(pdfSaveLocation);
            File f = new File(pdfSaveLocation + pdfFileName);
            this.log.info(f.getPath());
            if (!d.exists() && d.mkdirs()) {
                this.log.info(d.getName() + " was created successfully");
            }
            this.pdfBuilderService.generatePdf(pdfSaveLocation, pdfFileName, doc);
            if (f.exists() && !f.isDirectory()) {
                this.log.info(pdfFileName + " was created successfully.");
                this.emailService.sendMessage(DepartmentEmails.Payroll.getEmail(), pdfFileName, pdfSaveLocation + pdfFileName, uniform.getPortalUser().getEmail());
                response.setStatus(HttpStatus.OK.value());
                Uniform savedUniform = (Uniform)this.uniformRepository.save(uniform);
                formResponse.setFormName("Uniform Form");
                formResponse.setSuccess(true);
            }
        }
        catch (IOException | NullPointerException | DataAccessException ioExc) {
            error.setApiName("/hr/uniformSubmit");
            error.setErrorMessage(ioExc.getMessage());
            error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            formResponse.setFormName("Uniform Form");
            formResponse.setSuccess(false);
            formResponse.setApiError(error);
        }
        return formResponse;
    }
}

